/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.transforms;

import com.google.errorprone.annotations.Immutable;
import java.time.temporal.ChronoUnit;
import org.apache.iceberg.expressions.BoundPredicate;
import org.apache.iceberg.expressions.BoundTransform;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.UnboundPredicate;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.transforms.Dates;
import org.apache.iceberg.transforms.ProjectionUtil;
import org.apache.iceberg.transforms.TimeTransform;
import org.apache.iceberg.transforms.Transform;
import org.apache.iceberg.transforms.TransformUtil;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.DateTimeUtil;
import org.apache.iceberg.util.SerializableFunction;

enum Timestamps implements Transform<Long, Integer>
{
    MICROS_TO_YEAR(ChronoUnit.YEARS, "year", MicrosToYears.INSTANCE),
    MICROS_TO_MONTH(ChronoUnit.MONTHS, "month", MicrosToMonths.INSTANCE),
    MICROS_TO_DAY(ChronoUnit.DAYS, "day", MicrosToDays.INSTANCE),
    MICROS_TO_HOUR(ChronoUnit.HOURS, "hour", MicrosToHours.INSTANCE),
    NANOS_TO_YEAR(ChronoUnit.YEARS, "year", NanosToYears.INSTANCE),
    NANOS_TO_MONTH(ChronoUnit.MONTHS, "month", NanosToMonths.INSTANCE),
    NANOS_TO_DAY(ChronoUnit.DAYS, "day", NanosToDays.INSTANCE),
    NANOS_TO_HOUR(ChronoUnit.HOURS, "hour", NanosToHours.INSTANCE);

    private final ChronoUnit granularity;
    private final String name;
    private final SerializableFunction<Long, Integer> apply;

    private Timestamps(ChronoUnit granularity, String name, SerializableFunction<Long, Integer> apply) {
        this.name = name;
        this.granularity = granularity;
        this.apply = apply;
    }

    @Override
    @Deprecated
    public Integer apply(Long timestamp) {
        return (Integer)this.apply.apply((Integer)((Object)timestamp));
    }

    @Override
    public SerializableFunction<Long, Integer> bind(Type type) {
        Preconditions.checkArgument((boolean)this.canTransform(type), (String)"Cannot bind to unsupported type: %s", (Object)type);
        return this.apply;
    }

    @Override
    public boolean canTransform(Type type) {
        return type.typeId() == Type.TypeID.TIMESTAMP || type.typeId() == Type.TypeID.TIMESTAMP_NANO;
    }

    @Override
    public Type getResultType(Type sourceType) {
        if (this.granularity == ChronoUnit.DAYS) {
            return Types.DateType.get();
        }
        return Types.IntegerType.get();
    }

    ChronoUnit granularity() {
        return this.granularity;
    }

    @Override
    public boolean preservesOrder() {
        return true;
    }

    @Override
    public boolean satisfiesOrderOf(Transform<?, ?> other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Dates) {
            return TransformUtil.satisfiesOrderOf(this.granularity, ((Dates)other).granularity());
        }
        if (other instanceof Timestamps) {
            return TransformUtil.satisfiesOrderOf(this.granularity, ((Timestamps)other).granularity());
        }
        if (other instanceof TimeTransform) {
            return TransformUtil.satisfiesOrderOf(this.granularity, ((TimeTransform)other).granularity());
        }
        return false;
    }

    @Override
    public UnboundPredicate<Integer> project(String fieldName, BoundPredicate<Long> pred) {
        if (pred.term() instanceof BoundTransform) {
            return ProjectionUtil.projectTransformPredicate(this, fieldName, pred);
        }
        if (pred.isUnaryPredicate()) {
            return Expressions.predicate(pred.op(), fieldName);
        }
        if (pred.isLiteralPredicate()) {
            UnboundPredicate<Integer> projected = ProjectionUtil.truncateLong(fieldName, pred.asLiteralPredicate(), this.apply);
            return ProjectionUtil.fixInclusiveTimeProjection(projected);
        }
        if (pred.isSetPredicate() && pred.op() == Expression.Operation.IN) {
            UnboundPredicate<Integer> projected = ProjectionUtil.transformSet(fieldName, pred.asSetPredicate(), this.apply);
            return ProjectionUtil.fixInclusiveTimeProjection(projected);
        }
        return null;
    }

    @Override
    public UnboundPredicate<Integer> projectStrict(String fieldName, BoundPredicate<Long> pred) {
        if (pred.term() instanceof BoundTransform) {
            return ProjectionUtil.projectTransformPredicate(this, fieldName, pred);
        }
        if (pred.isUnaryPredicate()) {
            return Expressions.predicate(pred.op(), fieldName);
        }
        if (pred.isLiteralPredicate()) {
            UnboundPredicate<Integer> projected = ProjectionUtil.truncateLongStrict(fieldName, pred.asLiteralPredicate(), this.apply);
            return ProjectionUtil.fixStrictTimeProjection(projected);
        }
        if (pred.isSetPredicate() && pred.op() == Expression.Operation.NOT_IN) {
            UnboundPredicate<Integer> projected = ProjectionUtil.transformSet(fieldName, pred.asSetPredicate(), this.apply);
            return ProjectionUtil.fixStrictTimeProjection(projected);
        }
        return null;
    }

    @Override
    public String toHumanString(Type outputType, Integer value) {
        if (value == null) {
            return "null";
        }
        switch (this.granularity) {
            case YEARS: {
                return TransformUtil.humanYear(value);
            }
            case MONTHS: {
                return TransformUtil.humanMonth(value);
            }
            case DAYS: {
                return TransformUtil.humanDay(value);
            }
            case HOURS: {
                return TransformUtil.humanHour(value);
            }
        }
        throw new UnsupportedOperationException("Unsupported time unit: " + String.valueOf(this.granularity));
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String dedupName() {
        return "time";
    }

    @Immutable
    static class MicrosToYears
    implements SerializableFunction<Long, Integer> {
        static final MicrosToYears INSTANCE = new MicrosToYears();

        MicrosToYears() {
        }

        @Override
        public Integer apply(Long micros) {
            if (micros == null) {
                return null;
            }
            return DateTimeUtil.microsToYears(micros);
        }
    }

    @Immutable
    static class MicrosToMonths
    implements SerializableFunction<Long, Integer> {
        static final MicrosToMonths INSTANCE = new MicrosToMonths();

        MicrosToMonths() {
        }

        @Override
        public Integer apply(Long micros) {
            if (micros == null) {
                return null;
            }
            return DateTimeUtil.microsToMonths(micros);
        }
    }

    @Immutable
    static class MicrosToDays
    implements SerializableFunction<Long, Integer> {
        static final MicrosToDays INSTANCE = new MicrosToDays();

        MicrosToDays() {
        }

        @Override
        public Integer apply(Long micros) {
            if (micros == null) {
                return null;
            }
            return DateTimeUtil.microsToDays(micros);
        }
    }

    @Immutable
    static class MicrosToHours
    implements SerializableFunction<Long, Integer> {
        static final MicrosToHours INSTANCE = new MicrosToHours();

        MicrosToHours() {
        }

        @Override
        public Integer apply(Long micros) {
            if (micros == null) {
                return null;
            }
            return DateTimeUtil.microsToHours(micros);
        }
    }

    @Immutable
    static class NanosToYears
    implements SerializableFunction<Long, Integer> {
        static final NanosToYears INSTANCE = new NanosToYears();

        NanosToYears() {
        }

        @Override
        public Integer apply(Long nanos) {
            if (nanos == null) {
                return null;
            }
            return DateTimeUtil.nanosToYears(nanos);
        }
    }

    @Immutable
    static class NanosToMonths
    implements SerializableFunction<Long, Integer> {
        static final NanosToMonths INSTANCE = new NanosToMonths();

        NanosToMonths() {
        }

        @Override
        public Integer apply(Long nanos) {
            if (nanos == null) {
                return null;
            }
            return DateTimeUtil.nanosToMonths(nanos);
        }
    }

    @Immutable
    static class NanosToDays
    implements SerializableFunction<Long, Integer> {
        static final NanosToDays INSTANCE = new NanosToDays();

        NanosToDays() {
        }

        @Override
        public Integer apply(Long nanos) {
            if (nanos == null) {
                return null;
            }
            return DateTimeUtil.nanosToDays(nanos);
        }
    }

    @Immutable
    static class NanosToHours
    implements SerializableFunction<Long, Integer> {
        static final NanosToHours INSTANCE = new NanosToHours();

        NanosToHours() {
        }

        @Override
        public Integer apply(Long nanos) {
            if (nanos == null) {
                return null;
            }
            return DateTimeUtil.nanosToHours(nanos);
        }
    }
}

