/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.expressions;

import java.io.Serializable;
import java.util.Locale;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

public interface Expression
extends Serializable {
    public Operation op();

    default public Expression negate() {
        throw new UnsupportedOperationException(String.format("%s cannot be negated", this));
    }

    default public boolean isEquivalentTo(Expression other) {
        return false;
    }

    public static enum Operation {
        TRUE,
        FALSE,
        IS_NULL,
        NOT_NULL,
        IS_NAN,
        NOT_NAN,
        LT,
        LT_EQ,
        GT,
        GT_EQ,
        EQ,
        NOT_EQ,
        IN,
        NOT_IN,
        NOT,
        AND,
        OR,
        STARTS_WITH,
        NOT_STARTS_WITH,
        COUNT,
        COUNT_STAR,
        MAX,
        MIN;


        public static Operation fromString(String operationType) {
            Preconditions.checkArgument((null != operationType ? 1 : 0) != 0, (Object)"Invalid operation type: null");
            try {
                return Operation.valueOf(operationType.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("Invalid operation type: %s", operationType), e);
            }
        }

        public Operation negate() {
            switch (this.ordinal()) {
                case 2: {
                    return NOT_NULL;
                }
                case 3: {
                    return IS_NULL;
                }
                case 4: {
                    return NOT_NAN;
                }
                case 5: {
                    return IS_NAN;
                }
                case 6: {
                    return GT_EQ;
                }
                case 7: {
                    return GT;
                }
                case 8: {
                    return LT_EQ;
                }
                case 9: {
                    return LT;
                }
                case 10: {
                    return NOT_EQ;
                }
                case 11: {
                    return EQ;
                }
                case 12: {
                    return NOT_IN;
                }
                case 13: {
                    return IN;
                }
                case 17: {
                    return NOT_STARTS_WITH;
                }
                case 18: {
                    return STARTS_WITH;
                }
            }
            throw new IllegalArgumentException("No negation for operation: " + String.valueOf((Object)this));
        }

        public Operation flipLR() {
            switch (this.ordinal()) {
                case 6: {
                    return GT;
                }
                case 7: {
                    return GT_EQ;
                }
                case 8: {
                    return LT;
                }
                case 9: {
                    return LT_EQ;
                }
                case 10: {
                    return EQ;
                }
                case 11: {
                    return NOT_EQ;
                }
                case 15: {
                    return AND;
                }
                case 16: {
                    return OR;
                }
            }
            throw new IllegalArgumentException("No left-right flip for operation: " + String.valueOf((Object)this));
        }
    }
}

