/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.connect.events;

import java.util.List;
import java.util.UUID;
import org.apache.avro.Schema;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.connect.events.AvroUtil;
import org.apache.iceberg.connect.events.Payload;
import org.apache.iceberg.connect.events.PayloadType;
import org.apache.iceberg.connect.events.TableReference;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class DataWritten
implements Payload {
    private Types.StructType partitionType;
    private UUID commitId;
    private TableReference tableReference;
    private List<DataFile> dataFiles;
    private List<DeleteFile> deleteFiles;
    private Types.StructType icebergSchema;
    private final Schema avroSchema;
    static final int COMMIT_ID = 10300;
    static final int TABLE_REFERENCE = 10301;
    static final int DATA_FILES = 10302;
    static final int DATA_FILES_ELEMENT = 10303;
    static final int DELETE_FILES = 10304;
    static final int DELETE_FILES_ELEMENT = 10305;

    public DataWritten(Schema avroSchema) {
        this.avroSchema = avroSchema;
    }

    public DataWritten(Types.StructType partitionType, UUID commitId, TableReference tableReference, List<DataFile> dataFiles, List<DeleteFile> deleteFiles) {
        Preconditions.checkNotNull((Object)commitId, (Object)"Commit ID cannot be null");
        Preconditions.checkNotNull((Object)tableReference, (Object)"Table reference cannot be null");
        this.partitionType = partitionType;
        this.commitId = commitId;
        this.tableReference = tableReference;
        this.dataFiles = dataFiles;
        this.deleteFiles = deleteFiles;
        this.avroSchema = AvroUtil.convert(this.writeSchema(), this.getClass());
    }

    @Override
    public PayloadType type() {
        return PayloadType.DATA_WRITTEN;
    }

    public UUID commitId() {
        return this.commitId;
    }

    public TableReference tableReference() {
        return this.tableReference;
    }

    public List<DataFile> dataFiles() {
        return this.dataFiles;
    }

    public List<DeleteFile> deleteFiles() {
        return this.deleteFiles;
    }

    @Override
    public Types.StructType writeSchema() {
        if (this.icebergSchema == null) {
            Types.StructType dataFileStruct = DataFile.getType((Types.StructType)this.partitionType);
            this.icebergSchema = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)10300, (String)"commit_id", (Type)Types.UUIDType.get()), Types.NestedField.required((int)10301, (String)"table_reference", (Type)TableReference.ICEBERG_SCHEMA), Types.NestedField.optional((int)10302, (String)"data_files", (Type)Types.ListType.ofRequired((int)10303, (Type)dataFileStruct)), Types.NestedField.optional((int)10304, (String)"delete_files", (Type)Types.ListType.ofRequired((int)10305, (Type)dataFileStruct))});
        }
        return this.icebergSchema;
    }

    public Schema getSchema() {
        return this.avroSchema;
    }

    public void put(int i, Object v) {
        switch (AvroUtil.positionToId(i, this.avroSchema)) {
            case 10300: {
                this.commitId = (UUID)v;
                return;
            }
            case 10301: {
                this.tableReference = (TableReference)v;
                return;
            }
            case 10302: {
                this.dataFiles = (List)v;
                return;
            }
            case 10304: {
                this.deleteFiles = (List)v;
                return;
            }
        }
    }

    public Object get(int i) {
        switch (AvroUtil.positionToId(i, this.avroSchema)) {
            case 10300: {
                return this.commitId;
            }
            case 10301: {
                return this.tableReference;
            }
            case 10302: {
                return this.dataFiles;
            }
            case 10304: {
                return this.deleteFiles;
            }
        }
        throw new UnsupportedOperationException("Unknown field ordinal: " + i);
    }
}

