/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.connect.events;

import java.util.List;
import java.util.UUID;
import org.apache.avro.Schema;
import org.apache.iceberg.connect.events.AvroUtil;
import org.apache.iceberg.connect.events.Payload;
import org.apache.iceberg.connect.events.PayloadType;
import org.apache.iceberg.connect.events.TopicPartitionOffset;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class DataComplete
implements Payload {
    private UUID commitId;
    private List<TopicPartitionOffset> assignments;
    private final Schema avroSchema;
    static final int COMMIT_ID = 10100;
    static final int ASSIGNMENTS = 10101;
    static final int ASSIGNMENTS_ELEMENT = 10102;
    private static final Types.StructType ICEBERG_SCHEMA = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)10100, (String)"commit_id", (Type)Types.UUIDType.get()), Types.NestedField.optional((int)10101, (String)"assignments", (Type)Types.ListType.ofRequired((int)10102, (Type)TopicPartitionOffset.ICEBERG_SCHEMA))});
    private static final Schema AVRO_SCHEMA = AvroUtil.convert(ICEBERG_SCHEMA, DataComplete.class);

    public DataComplete(Schema avroSchema) {
        this.avroSchema = avroSchema;
    }

    public DataComplete(UUID commitId, List<TopicPartitionOffset> assignments) {
        Preconditions.checkNotNull((Object)commitId, (Object)"Commit ID cannot be null");
        this.commitId = commitId;
        this.assignments = assignments;
        this.avroSchema = AVRO_SCHEMA;
    }

    @Override
    public PayloadType type() {
        return PayloadType.DATA_COMPLETE;
    }

    public UUID commitId() {
        return this.commitId;
    }

    public List<TopicPartitionOffset> assignments() {
        return this.assignments;
    }

    @Override
    public Types.StructType writeSchema() {
        return ICEBERG_SCHEMA;
    }

    public Schema getSchema() {
        return this.avroSchema;
    }

    public void put(int i, Object v) {
        switch (AvroUtil.positionToId(i, this.avroSchema)) {
            case 10100: {
                this.commitId = (UUID)v;
                return;
            }
            case 10101: {
                this.assignments = (List)v;
                return;
            }
        }
    }

    public Object get(int i) {
        switch (AvroUtil.positionToId(i, this.avroSchema)) {
            case 10100: {
                return this.commitId;
            }
            case 10101: {
                return this.assignments;
            }
        }
        throw new UnsupportedOperationException("Unknown field ordinal: " + i);
    }
}

