/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.connect.events;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.iceberg.PartitionData;
import org.apache.iceberg.avro.AvroEncoderUtil;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.connect.events.Event;
import org.apache.iceberg.connect.events.TableReference;
import org.apache.iceberg.connect.events.TopicPartitionOffset;
import org.apache.iceberg.data.avro.DecoderResolver;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class AvroUtil {
    static final Map<Integer, String> FIELD_ID_TO_CLASS = ImmutableMap.of((Object)10102, (Object)TopicPartitionOffset.class.getName(), (Object)102, (Object)PartitionData.class.getName(), (Object)10301, (Object)TableReference.class.getName(), (Object)10303, (Object)"org.apache.iceberg.GenericDataFile", (Object)10305, (Object)"org.apache.iceberg.GenericDeleteFile", (Object)10401, (Object)TableReference.class.getName());

    public static byte[] encode(Event event) {
        try {
            return AvroEncoderUtil.encode((Object)event, (Schema)event.getSchema());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static Event decode(byte[] bytes) {
        try {
            Event event = (Event)AvroEncoderUtil.decode((byte[])bytes);
            DecoderResolver.clearCache();
            return event;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    static Schema convert(Types.StructType icebergSchema, Class<? extends IndexedRecord> javaClass) {
        return AvroUtil.convert(icebergSchema, javaClass, FIELD_ID_TO_CLASS);
    }

    static Schema convert(Types.StructType icebergSchema, Class<? extends IndexedRecord> javaClass, Map<Integer, String> typeMap) {
        return AvroSchemaUtil.convert((Type)icebergSchema, (T fieldId, U struct) -> struct.equals((Object)icebergSchema) ? javaClass.getName() : (String)typeMap.get(fieldId));
    }

    static int positionToId(int position, Schema avroSchema) {
        List fields = avroSchema.getFields();
        Preconditions.checkArgument((position >= 0 && position < fields.size() ? 1 : 0) != 0, (Object)("Invalid field position: " + position));
        Object val = ((Schema.Field)fields.get(position)).getObjectProp("field-id");
        return val == null ? -1 : (Integer)val;
    }

    private AvroUtil() {
    }
}

