/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.connect.data;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.SupportsNamespaces;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.connect.IcebergSinkConfig;
import org.apache.iceberg.connect.data.IcebergWriter;
import org.apache.iceberg.connect.data.NoOpWriter;
import org.apache.iceberg.connect.data.RecordWriter;
import org.apache.iceberg.connect.data.SchemaUtils;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.ForbiddenException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.Tasks;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.sink.SinkRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IcebergWriterFactory {
    private static final Logger LOG = LoggerFactory.getLogger(IcebergWriterFactory.class);
    private final Catalog catalog;
    private final IcebergSinkConfig config;

    IcebergWriterFactory(Catalog catalog, IcebergSinkConfig config) {
        this.catalog = catalog;
        this.config = config;
    }

    RecordWriter createWriter(String tableName, SinkRecord sample, boolean ignoreMissingTable) {
        Table table;
        TableIdentifier identifier = TableIdentifier.parse((String)tableName);
        try {
            table = this.catalog.loadTable(identifier);
        }
        catch (NoSuchTableException nst) {
            if (this.config.autoCreateEnabled()) {
                table = this.autoCreateTable(tableName, sample);
            }
            if (ignoreMissingTable) {
                return new NoOpWriter();
            }
            throw nst;
        }
        return new IcebergWriter(table, tableName, this.config);
    }

    @VisibleForTesting
    Table autoCreateTable(String tableName, SinkRecord sample) {
        PartitionSpec spec;
        Types.StructType structType;
        if (sample.valueSchema() == null) {
            Type type = SchemaUtils.inferIcebergType(sample.value(), this.config);
            if (type == null) {
                throw new DataException("Unable to create table from empty object");
            }
            structType = type.asStructType();
        } else {
            structType = SchemaUtils.toIcebergType(sample.valueSchema(), this.config).asStructType();
        }
        Schema schema = new Schema(structType.fields());
        TableIdentifier identifier = TableIdentifier.parse((String)tableName);
        IcebergWriterFactory.createNamespaceIfNotExist(this.catalog, identifier.namespace());
        List<String> partitionBy = this.config.tableConfig(tableName).partitionBy();
        try {
            spec = SchemaUtils.createPartitionSpec(schema, partitionBy);
        }
        catch (Exception e) {
            LOG.error("Unable to create partition spec {}, table {} will be unpartitioned", new Object[]{partitionBy, identifier, e});
            spec = PartitionSpec.unpartitioned();
        }
        PartitionSpec partitionSpec = spec;
        AtomicReference result = new AtomicReference();
        Tasks.range((int)1).retry(2).run(notUsed -> {
            try {
                result.set(this.catalog.createTable(identifier, schema, partitionSpec, this.config.autoCreateProps()));
            }
            catch (AlreadyExistsException e) {
                result.set(this.catalog.loadTable(identifier));
            }
        });
        return (Table)result.get();
    }

    @VisibleForTesting
    static void createNamespaceIfNotExist(Catalog catalog, Namespace identifierNamespace) {
        if (!(catalog instanceof SupportsNamespaces)) {
            return;
        }
        String[] levels = identifierNamespace.levels();
        for (int index = 0; index < levels.length; ++index) {
            Namespace namespace = Namespace.of((String[])Arrays.copyOfRange(levels, 0, index + 1));
            try {
                ((SupportsNamespaces)catalog).createNamespace(namespace);
                continue;
            }
            catch (AlreadyExistsException | ForbiddenException throwable) {
                // empty catch block
            }
        }
    }
}

