/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.connect.channel;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.connect.IcebergSinkConfig;
import org.apache.iceberg.connect.channel.Channel;
import org.apache.iceberg.connect.channel.Envelope;
import org.apache.iceberg.connect.channel.KafkaClientFactory;
import org.apache.iceberg.connect.data.Offset;
import org.apache.iceberg.connect.data.SinkWriter;
import org.apache.iceberg.connect.data.SinkWriterResult;
import org.apache.iceberg.connect.events.DataComplete;
import org.apache.iceberg.connect.events.DataWritten;
import org.apache.iceberg.connect.events.Event;
import org.apache.iceberg.connect.events.Payload;
import org.apache.iceberg.connect.events.PayloadType;
import org.apache.iceberg.connect.events.StartCommit;
import org.apache.iceberg.connect.events.TableReference;
import org.apache.iceberg.connect.events.TopicPartitionOffset;
import org.apache.kafka.connect.sink.SinkRecord;
import org.apache.kafka.connect.sink.SinkTaskContext;

class Worker
extends Channel {
    private final IcebergSinkConfig config;
    private final SinkTaskContext context;
    private final SinkWriter sinkWriter;

    Worker(IcebergSinkConfig config, KafkaClientFactory clientFactory, SinkWriter sinkWriter, SinkTaskContext context) {
        super("worker", config.controlGroupIdPrefix() + String.valueOf(UUID.randomUUID()), config, clientFactory, context);
        this.config = config;
        this.context = context;
        this.sinkWriter = sinkWriter;
    }

    void process() {
        this.consumeAvailable(Duration.ZERO);
    }

    @Override
    protected boolean receive(Envelope envelope) {
        Event event = envelope.event();
        if (event.payload().type() != PayloadType.START_COMMIT) {
            return false;
        }
        SinkWriterResult results = this.sinkWriter.completeWrite();
        List assignments = this.context.assignment().stream().map(tp -> {
            Offset offset = results.sourceOffsets().get(tp);
            if (offset == null) {
                offset = Offset.NULL_OFFSET;
            }
            return new TopicPartitionOffset(tp.topic(), tp.partition(), offset.offset(), offset.timestamp());
        }).collect(Collectors.toList());
        UUID commitId = ((StartCommit)event.payload()).commitId();
        List<Event> events = results.writerResults().stream().map(writeResult -> new Event(this.config.connectGroupId(), (Payload)new DataWritten(writeResult.partitionStruct(), commitId, TableReference.of((String)this.config.catalogName(), (TableIdentifier)writeResult.tableIdentifier()), writeResult.dataFiles(), writeResult.deleteFiles()))).collect(Collectors.toList());
        Event readyEvent = new Event(this.config.connectGroupId(), (Payload)new DataComplete(commitId, assignments));
        events.add(readyEvent);
        this.send(events, results.sourceOffsets());
        return true;
    }

    @Override
    void stop() {
        super.stop();
        this.sinkWriter.close();
    }

    void save(Collection<SinkRecord> sinkRecords) {
        this.sinkWriter.save(sinkRecords);
    }
}

