/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.connect.channel;

import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.iceberg.connect.IcebergSinkConfig;
import org.apache.iceberg.connect.channel.Envelope;
import org.apache.iceberg.connect.channel.KafkaClientFactory;
import org.apache.iceberg.connect.channel.KafkaUtils;
import org.apache.iceberg.connect.data.Offset;
import org.apache.iceberg.connect.events.AvroUtil;
import org.apache.iceberg.connect.events.Event;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.connect.sink.SinkTaskContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class Channel {
    private static final Logger LOG = LoggerFactory.getLogger(Channel.class);
    private final String controlTopic;
    private final String connectGroupId;
    private final Producer<String, byte[]> producer;
    private final Consumer<String, byte[]> consumer;
    private final SinkTaskContext context;
    private final Admin admin;
    private final Map<Integer, Long> controlTopicOffsets = Maps.newHashMap();
    private final String producerId;

    Channel(String name, String consumerGroupId, IcebergSinkConfig config, KafkaClientFactory clientFactory, SinkTaskContext context) {
        this.controlTopic = config.controlTopic();
        this.connectGroupId = config.connectGroupId();
        this.context = context;
        String transactionalId = config.transactionalPrefix() + name + config.transactionalSuffix();
        this.producer = clientFactory.createProducer(transactionalId);
        this.consumer = clientFactory.createConsumer(consumerGroupId);
        this.admin = clientFactory.createAdmin();
        this.producerId = UUID.randomUUID().toString();
    }

    protected void send(Event event) {
        this.send((List<Event>)ImmutableList.of((Object)event), (Map<TopicPartition, Offset>)ImmutableMap.of());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void send(List<Event> events, Map<TopicPartition, Offset> sourceOffsets) {
        HashMap offsetsToCommit = Maps.newHashMap();
        sourceOffsets.forEach((k, v) -> offsetsToCommit.put(k, new OffsetAndMetadata(v.offset().longValue())));
        List<ProducerRecord> recordList = events.stream().map(event -> {
            LOG.info("Sending event of type: {}", (Object)event.type().name());
            byte[] data = AvroUtil.encode((Event)event);
            return new ProducerRecord(this.controlTopic, (Object)this.producerId, (Object)data);
        }).collect(Collectors.toList());
        Producer<String, byte[]> producer = this.producer;
        synchronized (producer) {
            this.producer.beginTransaction();
            try {
                recordList.forEach(arg_0 -> this.producer.send(arg_0));
                if (!sourceOffsets.isEmpty()) {
                    this.producer.sendOffsetsToTransaction((Map)offsetsToCommit, KafkaUtils.consumerGroupMetadata(this.context));
                }
                this.producer.commitTransaction();
            }
            catch (Exception e) {
                try {
                    this.producer.abortTransaction();
                }
                catch (Exception ex) {
                    LOG.warn("Error aborting producer transaction", (Throwable)ex);
                }
                throw e;
            }
        }
    }

    protected abstract boolean receive(Envelope var1);

    protected void consumeAvailable(Duration pollDuration) {
        ConsumerRecords records = this.consumer.poll(pollDuration);
        while (!records.isEmpty()) {
            records.forEach(record -> {
                this.controlTopicOffsets.put(record.partition(), record.offset() + 1L);
                Event event = AvroUtil.decode((byte[])((byte[])record.value()));
                if (event.groupId().equals(this.connectGroupId)) {
                    LOG.debug("Received event of type: {}", (Object)event.type().name());
                    if (this.receive(new Envelope(event, record.partition(), record.offset()))) {
                        LOG.info("Handled event of type: {}", (Object)event.type().name());
                    }
                }
            });
            records = this.consumer.poll(pollDuration);
        }
    }

    protected Map<Integer, Long> controlTopicOffsets() {
        return this.controlTopicOffsets;
    }

    protected void commitConsumerOffsets() {
        HashMap offsetsToCommit = Maps.newHashMap();
        this.controlTopicOffsets().forEach((k, v) -> offsetsToCommit.put(new TopicPartition(this.controlTopic, k.intValue()), new OffsetAndMetadata(v.longValue())));
        this.consumer.commitSync((Map)offsetsToCommit);
    }

    void start() {
        this.consumer.subscribe((Collection)ImmutableList.of((Object)this.controlTopic));
        this.consumeAvailable(Duration.ofSeconds(1L));
    }

    void stop() {
        LOG.info("Channel stopping");
        this.producer.close();
        this.consumer.close();
        this.admin.close();
    }
}

