/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iceberg.io.IOUtil;
import org.apache.iceberg.parquet.ParquetValueWriter;
import org.apache.iceberg.parquet.TripleWriter;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.variants.PhysicalType;
import org.apache.iceberg.variants.ShreddedObject;
import org.apache.iceberg.variants.Variant;
import org.apache.iceberg.variants.VariantMetadata;
import org.apache.iceberg.variants.VariantObject;
import org.apache.iceberg.variants.VariantValue;
import org.apache.iceberg.variants.Variants;
import org.apache.parquet.column.ColumnWriteStore;

class ParquetVariantWriters {
    private ParquetVariantWriters() {
    }

    static ParquetValueWriter<Variant> variant(ParquetValueWriter<?> metadataWriter, ParquetValueWriter<?> valueWriter) {
        return new VariantWriter(metadataWriter, valueWriter);
    }

    static ParquetValueWriter<VariantMetadata> metadata(ParquetValueWriter<?> bytesWriter) {
        return new VariantMetadataWriter(bytesWriter);
    }

    static ParquetValueWriter<VariantValue> value(ParquetValueWriter<?> bytesWriter) {
        return new VariantValueWriter(bytesWriter);
    }

    static ParquetValueWriter<VariantValue> primitive(ParquetValueWriter<?> writer, PhysicalType ... types) {
        return new PrimitiveWriter(writer, (Set<PhysicalType>)Sets.immutableEnumSet(Arrays.asList(types)));
    }

    static ParquetValueWriter<VariantValue> shredded(int valueDefinitionLevel, ParquetValueWriter<?> valueWriter, int typedDefinitionLevel, ParquetValueWriter<?> typedWriter) {
        return new ShreddedVariantWriter(valueDefinitionLevel, valueWriter, typedDefinitionLevel, (TypedWriter)typedWriter);
    }

    static ParquetValueWriter<VariantValue> objects(int valueDefinitionLevel, ParquetValueWriter<?> valueWriter, int typedDefinitionLevel, int fieldDefinitionLevel, List<String> fieldNames, List<ParquetValueWriter<?>> fieldWriters) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int i = 0; i < fieldNames.size(); ++i) {
            builder.put((Object)fieldNames.get(i), fieldWriters.get(i));
        }
        return new ShreddedObjectWriter(valueDefinitionLevel, valueWriter, typedDefinitionLevel, fieldDefinitionLevel, (Map<String, ParquetValueWriter<VariantValue>>)builder.build());
    }

    private static void writeNull(ParquetValueWriter<?> writer, int repetitionLevel, int definitionLevel) {
        for (TripleWriter<?> column : writer.columns()) {
            column.writeNull(repetitionLevel, definitionLevel - 1);
        }
    }

    private static List<TripleWriter<?>> children(ParquetValueWriter<?> ... writers) {
        return ParquetVariantWriters.children(Arrays.asList(writers));
    }

    private static List<TripleWriter<?>> children(Iterable<ParquetValueWriter<?>> writers) {
        return ImmutableList.copyOf((Iterable)Iterables.concat((Iterable)Iterables.transform(writers, ParquetValueWriter::columns)));
    }

    private static class VariantWriter
    implements ParquetValueWriter<Variant> {
        private final ParquetValueWriter<VariantMetadata> metadataWriter;
        private final ParquetValueWriter<VariantValue> valueWriter;
        private final List<TripleWriter<?>> children;

        private VariantWriter(ParquetValueWriter<VariantMetadata> metadataWriter, ParquetValueWriter<VariantValue> valueWriter) {
            this.metadataWriter = metadataWriter;
            this.valueWriter = valueWriter;
            this.children = ParquetVariantWriters.children(metadataWriter, valueWriter);
        }

        @Override
        public void write(int repetitionLevel, Variant variant) {
            this.metadataWriter.write(repetitionLevel, variant.metadata());
            this.valueWriter.write(repetitionLevel, variant.value());
        }

        @Override
        public List<TripleWriter<?>> columns() {
            return this.children;
        }

        @Override
        public void setColumnStore(ColumnWriteStore columnStore) {
            this.metadataWriter.setColumnStore(columnStore);
            this.valueWriter.setColumnStore(columnStore);
        }
    }

    private static class VariantMetadataWriter
    extends VariantBinaryWriter<VariantMetadata> {
        private VariantMetadataWriter(ParquetValueWriter<ByteBuffer> bytesWriter) {
            super(bytesWriter);
        }

        @Override
        protected int sizeInBytes(VariantMetadata metadata) {
            return metadata.sizeInBytes();
        }

        @Override
        protected int writeTo(ByteBuffer buffer, int offset, VariantMetadata metadata) {
            return metadata.writeTo(buffer, offset);
        }
    }

    private static class VariantValueWriter
    extends VariantBinaryWriter<VariantValue> {
        private VariantValueWriter(ParquetValueWriter<ByteBuffer> bytesWriter) {
            super(bytesWriter);
        }

        @Override
        protected int sizeInBytes(VariantValue value) {
            return value.sizeInBytes();
        }

        @Override
        protected int writeTo(ByteBuffer buffer, int offset, VariantValue value) {
            return value.writeTo(buffer, offset);
        }
    }

    private static class PrimitiveWriter<T>
    implements TypedWriter {
        private final Set<PhysicalType> types;
        private final ParquetValueWriter<T> writer;

        private PrimitiveWriter(ParquetValueWriter<T> writer, Set<PhysicalType> types) {
            this.types = types;
            this.writer = writer;
        }

        @Override
        public Set<PhysicalType> types() {
            return this.types;
        }

        @Override
        public void write(int repetitionLevel, VariantValue value) {
            this.writer.write(repetitionLevel, value.asPrimitive().get());
        }

        @Override
        public List<TripleWriter<?>> columns() {
            return this.writer.columns();
        }

        @Override
        public void setColumnStore(ColumnWriteStore columnStore) {
            this.writer.setColumnStore(columnStore);
        }
    }

    private static class ShreddedVariantWriter
    implements ParquetValueWriter<VariantValue> {
        private final int valueDefinitionLevel;
        private final ParquetValueWriter<VariantValue> valueWriter;
        private final int typedDefinitionLevel;
        private final TypedWriter typedWriter;
        private final List<TripleWriter<?>> children;

        private ShreddedVariantWriter(int valueDefinitionLevel, ParquetValueWriter<VariantValue> valueWriter, int typedDefinitionLevel, TypedWriter typedWriter) {
            this.valueDefinitionLevel = valueDefinitionLevel;
            this.valueWriter = valueWriter;
            this.typedDefinitionLevel = typedDefinitionLevel;
            this.typedWriter = typedWriter;
            this.children = ParquetVariantWriters.children(valueWriter, typedWriter);
        }

        @Override
        public void write(int repetitionLevel, VariantValue value) {
            if (this.typedWriter.types().contains(value.type())) {
                this.typedWriter.write(repetitionLevel, value);
                ParquetVariantWriters.writeNull(this.valueWriter, repetitionLevel, this.valueDefinitionLevel);
            } else {
                this.valueWriter.write(repetitionLevel, value);
                ParquetVariantWriters.writeNull(this.typedWriter, repetitionLevel, this.typedDefinitionLevel);
            }
        }

        @Override
        public List<TripleWriter<?>> columns() {
            return this.children;
        }

        @Override
        public void setColumnStore(ColumnWriteStore columnStore) {
            this.valueWriter.setColumnStore(columnStore);
            this.typedWriter.setColumnStore(columnStore);
        }
    }

    private static interface TypedWriter
    extends ParquetValueWriter<VariantValue> {
        public Set<PhysicalType> types();
    }

    private static class ShreddedObjectWriter
    implements ParquetValueWriter<VariantValue> {
        private final int valueDefinitionLevel;
        private final ParquetValueWriter<VariantValue> valueWriter;
        private final int typedDefinitionLevel;
        private final int fieldDefinitionLevel;
        private final Map<String, ParquetValueWriter<VariantValue>> typedWriters;
        private final List<TripleWriter<?>> children;

        private ShreddedObjectWriter(int valueDefinitionLevel, ParquetValueWriter<VariantValue> valueWriter, int typedDefinitionLevel, int fieldDefinitionLevel, Map<String, ParquetValueWriter<VariantValue>> typedWriters) {
            this.valueDefinitionLevel = valueDefinitionLevel;
            this.valueWriter = valueWriter;
            this.typedDefinitionLevel = typedDefinitionLevel;
            this.fieldDefinitionLevel = fieldDefinitionLevel;
            this.typedWriters = typedWriters;
            this.children = ParquetVariantWriters.children(Iterables.concat((Iterable)ImmutableList.of(valueWriter), (Iterable)ImmutableList.copyOf(typedWriters.values())));
        }

        @Override
        public void write(int repetitionLevel, VariantValue value) {
            if (value.type() != PhysicalType.OBJECT) {
                this.valueWriter.write(repetitionLevel, value);
                for (ParquetValueWriter<VariantValue> writer : this.typedWriters.values()) {
                    ParquetVariantWriters.writeNull(writer, repetitionLevel, this.typedDefinitionLevel);
                }
            } else {
                VariantObject object = value.asObject();
                ShreddedObject shredded = Variants.object((VariantObject)object);
                for (Map.Entry<String, ParquetValueWriter<VariantValue>> entry : this.typedWriters.entrySet()) {
                    String fieldName = entry.getKey();
                    ParquetValueWriter<VariantValue> writer = entry.getValue();
                    VariantValue fieldValue = object.get(fieldName);
                    if (fieldValue != null) {
                        shredded.remove(fieldName);
                        writer.write(repetitionLevel, fieldValue);
                        continue;
                    }
                    ParquetVariantWriters.writeNull(writer, repetitionLevel, this.fieldDefinitionLevel);
                }
                if (shredded.numFields() > 0) {
                    this.valueWriter.write(repetitionLevel, (VariantValue)shredded);
                } else {
                    ParquetVariantWriters.writeNull(this.valueWriter, repetitionLevel, this.valueDefinitionLevel);
                }
            }
        }

        @Override
        public List<TripleWriter<?>> columns() {
            return this.children;
        }

        @Override
        public void setColumnStore(ColumnWriteStore columnStore) {
            this.valueWriter.setColumnStore(columnStore);
            for (ParquetValueWriter<VariantValue> fieldWriter : this.typedWriters.values()) {
                fieldWriter.setColumnStore(columnStore);
            }
        }
    }

    private static abstract class VariantBinaryWriter<T>
    implements ParquetValueWriter<T> {
        private final ParquetValueWriter<ByteBuffer> bytesWriter;
        private ByteBuffer reusedBuffer = ByteBuffer.allocate(2048).order(ByteOrder.LITTLE_ENDIAN);

        private VariantBinaryWriter(ParquetValueWriter<ByteBuffer> bytesWriter) {
            this.bytesWriter = bytesWriter;
        }

        protected abstract int sizeInBytes(T var1);

        protected abstract int writeTo(ByteBuffer var1, int var2, T var3);

        @Override
        public void write(int repetitionLevel, T value) {
            this.bytesWriter.write(repetitionLevel, this.serialize(value));
        }

        @Override
        public List<TripleWriter<?>> columns() {
            return this.bytesWriter.columns();
        }

        @Override
        public void setColumnStore(ColumnWriteStore columnStore) {
            this.bytesWriter.setColumnStore(columnStore);
        }

        private void ensureCapacity(int requiredSize) {
            if (this.reusedBuffer.capacity() < requiredSize) {
                int newCapacity = IOUtil.capacityFor((int)requiredSize);
                this.reusedBuffer = ByteBuffer.allocate(newCapacity).order(ByteOrder.LITTLE_ENDIAN);
            } else {
                this.reusedBuffer.limit(requiredSize);
            }
        }

        private ByteBuffer serialize(T value) {
            this.ensureCapacity(this.sizeInBytes(value));
            int size = this.writeTo(this.reusedBuffer, 0, value);
            this.reusedBuffer.position(0);
            this.reusedBuffer.limit(size);
            return this.reusedBuffer;
        }
    }
}

