/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.iceberg.FieldMetrics;
import org.apache.iceberg.Metrics;
import org.apache.iceberg.MetricsConfig;
import org.apache.iceberg.MetricsModes;
import org.apache.iceberg.MetricsUtil;
import org.apache.iceberg.Schema;
import org.apache.iceberg.parquet.ParquetConversions;
import org.apache.iceberg.parquet.ParquetVariantUtil;
import org.apache.iceberg.parquet.ParquetVariantVisitor;
import org.apache.iceberg.parquet.TypeWithSchemaVisitor;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Multimap;
import org.apache.iceberg.relocated.com.google.common.collect.Multimaps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.relocated.com.google.common.collect.Streams;
import org.apache.iceberg.types.Comparators;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.BinaryUtil;
import org.apache.iceberg.util.NaNUtil;
import org.apache.iceberg.util.UnicodeUtil;
import org.apache.iceberg.variants.PhysicalType;
import org.apache.iceberg.variants.ShreddedObject;
import org.apache.iceberg.variants.VariantMetadata;
import org.apache.iceberg.variants.VariantPrimitive;
import org.apache.iceberg.variants.VariantValue;
import org.apache.iceberg.variants.Variants;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;

class ParquetMetrics {
    private ParquetMetrics() {
    }

    static Metrics metrics(Schema schema, MessageType type, MetricsConfig metricsConfig, ParquetMetadata metadata, Stream<FieldMetrics<?>> fields) {
        long rowCount = 0L;
        HashMap columnSizes = Maps.newHashMap();
        Multimap columns = Multimaps.newMultimap((Map)Maps.newHashMap(), Lists::newArrayList);
        for (BlockMetaData block : metadata.getBlocks()) {
            rowCount += block.getRowCount();
            for (ColumnChunkMetaData column : block.getColumns()) {
                int fieldId;
                MetricsModes.MetricsMode mode;
                columns.put((Object)column.getPath(), (Object)column);
                Type.ID id = type.getColumnDescription(column.getPath().toArray()).getPrimitiveType().getId();
                if (null == id || (mode = MetricsUtil.metricsMode((Schema)schema, (MetricsConfig)metricsConfig, (int)(fieldId = id.intValue()))) == MetricsModes.None.get()) continue;
                columnSizes.put(fieldId, columnSizes.getOrDefault(fieldId, 0L) + column.getTotalSize());
            }
        }
        Map<Integer, FieldMetrics<?>> metricsById = fields.collect(Collectors.toMap(FieldMetrics::id, Function.identity()));
        Iterable<FieldMetrics<ByteBuffer>> results = TypeWithSchemaVisitor.visit((Type)schema.asStruct(), (org.apache.parquet.schema.Type)type, new MetricsVisitor(schema, metricsConfig, metricsById, (Multimap<ColumnPath, ColumnChunkMetaData>)columns));
        HashMap valueCounts = Maps.newHashMap();
        HashMap nullValueCounts = Maps.newHashMap();
        HashMap nanValueCounts = Maps.newHashMap();
        HashMap lowerBounds = Maps.newHashMap();
        HashMap upperBounds = Maps.newHashMap();
        for (FieldMetrics<ByteBuffer> metrics : results) {
            int id = metrics.id();
            if (metrics.valueCount() >= 0L) {
                valueCounts.put(id, metrics.valueCount());
            }
            if (metrics.nullValueCount() >= 0L) {
                nullValueCounts.put(id, metrics.nullValueCount());
            }
            if (metrics.nanValueCount() >= 0L) {
                nanValueCounts.put(id, metrics.nanValueCount());
            }
            if (metrics.lowerBound() != null) {
                lowerBounds.put(id, (ByteBuffer)metrics.lowerBound());
            }
            if (metrics.upperBound() == null) continue;
            upperBounds.put(id, (ByteBuffer)metrics.upperBound());
        }
        return new Metrics(Long.valueOf(rowCount), (Map)columnSizes, (Map)valueCounts, (Map)nullValueCounts, (Map)nanValueCounts, (Map)lowerBounds, (Map)upperBounds);
    }

    private static int truncateLength(MetricsModes.MetricsMode mode) {
        if (mode == MetricsModes.None.get()) {
            return 0;
        }
        if (mode == MetricsModes.Counts.get()) {
            return 0;
        }
        if (mode instanceof MetricsModes.Truncate) {
            return ((MetricsModes.Truncate)mode).length();
        }
        return Integer.MAX_VALUE;
    }

    private static <T> T truncateLowerBound(Type.PrimitiveType type, T value, int length) {
        if (null == value) {
            return null;
        }
        switch (type.typeId()) {
            case STRING: {
                return (T)UnicodeUtil.truncateStringMin((String)((String)value), (int)length);
            }
            case BINARY: {
                return (T)BinaryUtil.truncateBinaryMin((ByteBuffer)((ByteBuffer)value), (int)length);
            }
        }
        return value;
    }

    private static <T> T truncateUpperBound(Type.PrimitiveType type, T value, int length) {
        if (null == value) {
            return null;
        }
        switch (type.typeId()) {
            case STRING: {
                return (T)UnicodeUtil.truncateStringMax((String)((String)value), (int)length);
            }
            case BINARY: {
                return (T)BinaryUtil.truncateBinaryMax((ByteBuffer)((ByteBuffer)value), (int)length);
            }
        }
        return value;
    }

    private static class MetricsVisitor
    extends TypeWithSchemaVisitor<Iterable<FieldMetrics<ByteBuffer>>> {
        private final Schema schema;
        private final MetricsConfig metricsConfig;
        private final Map<Integer, FieldMetrics<?>> metricsById;
        private final Multimap<ColumnPath, ColumnChunkMetaData> columns;

        private MetricsVisitor(Schema schema, MetricsConfig metricsConfig, Map<Integer, FieldMetrics<?>> metricsById, Multimap<ColumnPath, ColumnChunkMetaData> columns) {
            this.schema = schema;
            this.metricsConfig = metricsConfig;
            this.metricsById = metricsById;
            this.columns = columns;
        }

        @Override
        public Iterable<FieldMetrics<ByteBuffer>> message(Types.StructType iStruct, MessageType message, List<Iterable<FieldMetrics<ByteBuffer>>> fieldResults) {
            return Iterables.concat(fieldResults);
        }

        @Override
        public Iterable<FieldMetrics<ByteBuffer>> struct(Types.StructType iStruct, GroupType struct, List<Iterable<FieldMetrics<ByteBuffer>>> fieldResults) {
            return Iterables.concat(fieldResults);
        }

        @Override
        public Iterable<FieldMetrics<ByteBuffer>> list(Types.ListType iList, GroupType array, Iterable<FieldMetrics<ByteBuffer>> elementResults) {
            return ImmutableList.of();
        }

        @Override
        public Iterable<FieldMetrics<ByteBuffer>> map(Types.MapType iMap, GroupType map, Iterable<FieldMetrics<ByteBuffer>> keyResults, Iterable<FieldMetrics<ByteBuffer>> valueResults) {
            return ImmutableList.of();
        }

        @Override
        public Iterable<FieldMetrics<ByteBuffer>> primitive(Type.PrimitiveType iPrimitive, PrimitiveType primitive) {
            Type.ID id = primitive.getId();
            if (null == id) {
                return ImmutableList.of();
            }
            int fieldId = id.intValue();
            MetricsModes.MetricsMode mode = MetricsUtil.metricsMode((Schema)this.schema, (MetricsConfig)this.metricsConfig, (int)fieldId);
            if (mode == MetricsModes.None.get()) {
                return ImmutableList.of();
            }
            int length = ParquetMetrics.truncateLength(mode);
            FieldMetrics<ByteBuffer> metrics = this.metricsFromFieldMetrics(fieldId, iPrimitive, length);
            if (metrics != null) {
                return ImmutableList.of(metrics);
            }
            metrics = this.metricsFromFooter(fieldId, iPrimitive, primitive, length);
            if (metrics != null) {
                return ImmutableList.of(metrics);
            }
            return ImmutableList.of();
        }

        private FieldMetrics<ByteBuffer> metricsFromFieldMetrics(int fieldId, Type.PrimitiveType icebergType, int truncateLength) {
            FieldMetrics<?> fieldMetrics = this.metricsById.get(fieldId);
            if (null == fieldMetrics) {
                return null;
            }
            if (truncateLength <= 0) {
                return new FieldMetrics(fieldMetrics.id(), fieldMetrics.valueCount(), fieldMetrics.nullValueCount(), fieldMetrics.nanValueCount());
            }
            Object lowerBound = ParquetMetrics.truncateLowerBound(icebergType, fieldMetrics.lowerBound(), truncateLength);
            Object upperBound = ParquetMetrics.truncateUpperBound(icebergType, fieldMetrics.upperBound(), truncateLength);
            ByteBuffer lower = Conversions.toByteBuffer((Type)icebergType, (Object)lowerBound);
            ByteBuffer upper = Conversions.toByteBuffer((Type)icebergType, (Object)upperBound);
            return new FieldMetrics(fieldMetrics.id(), fieldMetrics.valueCount(), fieldMetrics.nullValueCount(), fieldMetrics.nanValueCount(), (Object)lower, (Object)upper);
        }

        private FieldMetrics<ByteBuffer> metricsFromFooter(int fieldId, Type.PrimitiveType icebergType, PrimitiveType primitive, int truncateLength) {
            if (primitive.getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.INT96) {
                return null;
            }
            if (truncateLength <= 0) {
                return this.counts(fieldId);
            }
            return this.bounds(fieldId, icebergType, primitive, truncateLength);
        }

        private FieldMetrics<ByteBuffer> counts(int fieldId) {
            ColumnPath path = ColumnPath.get((String[])this.currentPath());
            long valueCount = 0L;
            long nullCount = 0L;
            for (ColumnChunkMetaData column : this.columns.get((Object)path)) {
                Statistics stats = column.getStatistics();
                if (stats == null || stats.isEmpty()) {
                    return null;
                }
                nullCount += stats.getNumNulls();
                valueCount += column.getValueCount();
            }
            return new FieldMetrics(fieldId, valueCount, nullCount);
        }

        private <T> FieldMetrics<ByteBuffer> bounds(int fieldId, Type.PrimitiveType icebergType, PrimitiveType primitive, int truncateLength) {
            if (icebergType == null) {
                return null;
            }
            ColumnPath path = ColumnPath.get((String[])this.currentPath());
            Comparator comparator = Comparators.forType((Type.PrimitiveType)icebergType);
            long valueCount = 0L;
            long nullCount = 0L;
            Object lowerBound = null;
            Object upperBound = null;
            for (ColumnChunkMetaData column : this.columns.get((Object)path)) {
                Statistics stats = column.getStatistics();
                if (stats == null || stats.isEmpty()) {
                    return null;
                }
                nullCount += stats.getNumNulls();
                valueCount += column.getValueCount();
                if (!stats.hasNonNullValue()) continue;
                Object chunkMin = ParquetConversions.convertValue((Type)icebergType, primitive, stats.genericGetMin());
                if (lowerBound == null || comparator.compare(chunkMin, lowerBound) < 0) {
                    lowerBound = chunkMin;
                }
                Object chunkMax = ParquetConversions.convertValue((Type)icebergType, primitive, stats.genericGetMax());
                if (upperBound != null && comparator.compare(chunkMax, upperBound) <= 0) continue;
                upperBound = chunkMax;
            }
            if (NaNUtil.isNaN(lowerBound) || NaNUtil.isNaN(upperBound)) {
                return new FieldMetrics(fieldId, valueCount, nullCount);
            }
            lowerBound = ParquetMetrics.truncateLowerBound(icebergType, lowerBound, truncateLength);
            upperBound = ParquetMetrics.truncateUpperBound(icebergType, upperBound, truncateLength);
            ByteBuffer lower = Conversions.toByteBuffer((Type)icebergType, lowerBound);
            ByteBuffer upper = Conversions.toByteBuffer((Type)icebergType, upperBound);
            return new FieldMetrics(fieldId, valueCount, nullCount, (Object)lower, (Object)upper);
        }

        @Override
        public Iterable<FieldMetrics<ByteBuffer>> variant(Types.VariantType iVariant, GroupType variant, Iterable<FieldMetrics<ByteBuffer>> ignored) {
            Type.ID id = variant.getId();
            if (null == id) {
                return ImmutableList.of();
            }
            int fieldId = id.intValue();
            MetricsModes.MetricsMode mode = MetricsUtil.metricsMode((Schema)this.schema, (MetricsConfig)this.metricsConfig, (int)fieldId);
            if (mode == MetricsModes.None.get()) {
                return ImmutableList.of();
            }
            ArrayList results = Lists.newArrayList(ParquetVariantVisitor.visit(variant, new MetricsVariantVisitor(this.currentPath())));
            if (results.isEmpty()) {
                return ImmutableList.of();
            }
            ParquetVariantUtil.VariantMetrics metadataCounts = (ParquetVariantUtil.VariantMetrics)results.get(0);
            if (mode == MetricsModes.Counts.get() || results.size() == 1) {
                return ImmutableList.of((Object)new FieldMetrics(fieldId, metadataCounts.valueCount(), metadataCounts.nullCount()));
            }
            TreeSet fieldNames = Sets.newTreeSet();
            for (ParquetVariantUtil.VariantMetrics result : results.subList(1, results.size())) {
                if (result.lowerBound() == null && result.upperBound() == null) continue;
                fieldNames.add(result.fieldName());
            }
            if (fieldNames.isEmpty()) {
                return ImmutableList.of((Object)new FieldMetrics(fieldId, metadataCounts.valueCount(), metadataCounts.nullCount()));
            }
            VariantMetadata metadata = Variants.metadata((Collection)fieldNames);
            ShreddedObject lowerBounds = Variants.object((VariantMetadata)metadata);
            ShreddedObject upperBounds = Variants.object((VariantMetadata)metadata);
            for (ParquetVariantUtil.VariantMetrics result : results.subList(1, results.size())) {
                String fieldName = result.fieldName();
                if (result.lowerBound() != null) {
                    lowerBounds.put(fieldName, result.lowerBound());
                }
                if (result.upperBound() == null) continue;
                upperBounds.put(fieldName, result.upperBound());
            }
            return ImmutableList.of((Object)new FieldMetrics(fieldId, metadataCounts.valueCount(), metadataCounts.nullCount(), (Object)ParquetVariantUtil.toByteBuffer(metadata, (VariantValue)lowerBounds), (Object)ParquetVariantUtil.toByteBuffer(metadata, (VariantValue)upperBounds)));
        }

        private class MetricsVariantVisitor
        extends ParquetVariantVisitor<Iterable<ParquetVariantUtil.VariantMetrics>> {
            private final Deque<String> fieldNames = Lists.newLinkedList();
            private final String[] basePath;

            private MetricsVariantVisitor(String[] basePath) {
                this.basePath = basePath;
            }

            @Override
            public void beforeField(org.apache.parquet.schema.Type type) {
                this.fieldNames.addLast(type.getName());
            }

            @Override
            public void afterField(org.apache.parquet.schema.Type type) {
                this.fieldNames.removeLast();
            }

            private Stream<String> currentPath() {
                return Streams.concat((Stream[])new Stream[]{Stream.of(this.basePath), this.fieldNames.stream()});
            }

            @Override
            public Iterable<ParquetVariantUtil.VariantMetrics> variant(GroupType variant, Iterable<ParquetVariantUtil.VariantMetrics> metadataResults, Iterable<ParquetVariantUtil.VariantMetrics> valueResults) {
                return Iterables.concat(metadataResults, valueResults);
            }

            @Override
            public Iterable<ParquetVariantUtil.VariantMetrics> object(GroupType object, Iterable<ParquetVariantUtil.VariantMetrics> valueResult, List<Iterable<ParquetVariantUtil.VariantMetrics>> fieldResults) {
                GroupType shreddedFields = object.getType("typed_value").asGroupType();
                ArrayList results = Lists.newArrayList();
                for (int i = 0; i < fieldResults.size(); ++i) {
                    String name = shreddedFields.getFieldName(i);
                    results.add(Iterables.transform(fieldResults.get(i), result -> result.prependFieldName(name)));
                }
                return Iterables.concat((Iterable)results);
            }

            @Override
            public Iterable<ParquetVariantUtil.VariantMetrics> array(GroupType array, Iterable<ParquetVariantUtil.VariantMetrics> valueResult, Iterable<ParquetVariantUtil.VariantMetrics> elementResult) {
                return ImmutableList.of();
            }

            @Override
            public Iterable<ParquetVariantUtil.VariantMetrics> value(GroupType value, Iterable<ParquetVariantUtil.VariantMetrics> valueResult, Iterable<ParquetVariantUtil.VariantMetrics> typedResult) {
                if (null == valueResult) {
                    return typedResult;
                }
                ParquetVariantUtil.VariantMetrics valueMetrics = (ParquetVariantUtil.VariantMetrics)Iterables.getOnlyElement(valueResult);
                if (typedResult != null && valueMetrics.valueCount() == valueMetrics.nullCount()) {
                    return typedResult;
                }
                return ImmutableList.of();
            }

            @Override
            public Iterable<ParquetVariantUtil.VariantMetrics> metadata(PrimitiveType metadata) {
                ParquetVariantUtil.VariantMetrics counts = this.counts();
                if (counts != null) {
                    return ImmutableList.of((Object)counts);
                }
                return ImmutableList.of();
            }

            @Override
            public Iterable<ParquetVariantUtil.VariantMetrics> serialized(PrimitiveType value) {
                ParquetVariantUtil.VariantMetrics counts = this.counts();
                if (counts != null) {
                    return ImmutableList.of((Object)counts);
                }
                return ImmutableList.of();
            }

            @Override
            public Iterable<ParquetVariantUtil.VariantMetrics> primitive(PrimitiveType primitive) {
                ParquetVariantUtil.VariantMetrics result = this.metrics(primitive);
                if (result != null) {
                    return ImmutableList.of((Object)result);
                }
                return ImmutableList.of();
            }

            private ParquetVariantUtil.VariantMetrics counts() {
                ColumnPath path = ColumnPath.get((String[])((String[])this.currentPath().toArray(String[]::new)));
                long valueCount = 0L;
                long nullCount = 0L;
                for (ColumnChunkMetaData column : MetricsVisitor.this.columns.get((Object)path)) {
                    Statistics stats = column.getStatistics();
                    if (stats == null || stats.isEmpty()) {
                        return null;
                    }
                    boolean hasOnlyNullVariants = stats.hasNonNullValue() ? Variants.isNull((ByteBuffer)ByteBuffer.wrap(stats.getMinBytes())) && Variants.isNull((ByteBuffer)ByteBuffer.wrap(stats.getMaxBytes())) : false;
                    valueCount += column.getValueCount();
                    nullCount += hasOnlyNullVariants ? column.getValueCount() : stats.getNumNulls();
                }
                return new ParquetVariantUtil.VariantMetrics(valueCount, nullCount);
            }

            private <T> ParquetVariantUtil.VariantMetrics metrics(PrimitiveType primitive) {
                PhysicalType variantType = ParquetVariantUtil.convert(primitive);
                if (null == variantType) {
                    return null;
                }
                ColumnPath path = ColumnPath.get((String[])((String[])this.currentPath().toArray(String[]::new)));
                Comparator<Object> comparator = ParquetVariantUtil.comparator(variantType);
                int scale = ParquetVariantUtil.scale(primitive);
                long valueCount = 0L;
                long nullCount = 0L;
                Object lowerBound = null;
                Object upperBound = null;
                for (ColumnChunkMetaData column : MetricsVisitor.this.columns.get((Object)path)) {
                    Statistics stats = column.getStatistics();
                    if (stats == null || stats.isEmpty()) {
                        return null;
                    }
                    nullCount += stats.getNumNulls();
                    valueCount += column.getValueCount();
                    if (!stats.hasNonNullValue()) continue;
                    Object chunkMin = ParquetVariantUtil.convertValue(variantType, scale, stats.genericGetMin());
                    if (lowerBound == null || comparator.compare(chunkMin, lowerBound) < 0) {
                        lowerBound = chunkMin;
                    }
                    Object chunkMax = ParquetVariantUtil.convertValue(variantType, scale, stats.genericGetMax());
                    if (upperBound != null && comparator.compare(chunkMax, upperBound) <= 0) continue;
                    upperBound = chunkMax;
                }
                if (NaNUtil.isNaN(lowerBound) || NaNUtil.isNaN(upperBound)) {
                    return null;
                }
                if (lowerBound != null && upperBound != null) {
                    VariantPrimitive lower = Variants.of((PhysicalType)variantType, lowerBound);
                    VariantPrimitive upper = Variants.of((PhysicalType)variantType, upperBound);
                    return new ParquetVariantUtil.VariantMetrics(valueCount, nullCount, (VariantValue)lower, (VariantValue)upper);
                }
                return new ParquetVariantUtil.VariantMetrics(valueCount, nullCount);
            }
        }
    }
}

