/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import org.apache.iceberg.parquet.BaseColumnIterator;
import org.apache.iceberg.parquet.BasePageIterator;
import org.apache.iceberg.parquet.PageIterator;
import org.apache.iceberg.parquet.TripleIterator;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.io.api.Binary;

public abstract class ColumnIterator<T>
extends BaseColumnIterator
implements TripleIterator<T> {
    private final PageIterator<T> pageIterator;

    static <T> ColumnIterator<T> newIterator(ColumnDescriptor desc, String writerVersion) {
        switch (desc.getPrimitiveType().getPrimitiveTypeName()) {
            case BOOLEAN: {
                return new ColumnIterator<Boolean>(desc, writerVersion){

                    @Override
                    public Boolean next() {
                        return this.nextBoolean();
                    }
                };
            }
            case INT32: {
                return new ColumnIterator<Integer>(desc, writerVersion){

                    @Override
                    public Integer next() {
                        return this.nextInteger();
                    }
                };
            }
            case INT64: {
                return new ColumnIterator<Long>(desc, writerVersion){

                    @Override
                    public Long next() {
                        return this.nextLong();
                    }
                };
            }
            case INT96: {
                return new ColumnIterator<Binary>(desc, writerVersion){

                    @Override
                    public Binary next() {
                        return this.nextBinary();
                    }
                };
            }
            case FLOAT: {
                return new ColumnIterator<Float>(desc, writerVersion){

                    @Override
                    public Float next() {
                        return Float.valueOf(this.nextFloat());
                    }
                };
            }
            case DOUBLE: {
                return new ColumnIterator<Double>(desc, writerVersion){

                    @Override
                    public Double next() {
                        return this.nextDouble();
                    }
                };
            }
            case FIXED_LEN_BYTE_ARRAY: 
            case BINARY: {
                return new ColumnIterator<Binary>(desc, writerVersion){

                    @Override
                    public Binary next() {
                        return this.nextBinary();
                    }
                };
            }
        }
        throw new UnsupportedOperationException("Unsupported primitive type: " + String.valueOf(desc.getPrimitiveType().getPrimitiveTypeName()));
    }

    private ColumnIterator(ColumnDescriptor desc, String writerVersion) {
        super(desc);
        this.pageIterator = PageIterator.newIterator(desc, writerVersion);
    }

    @Override
    public int currentDefinitionLevel() {
        this.advance();
        return this.pageIterator.currentDefinitionLevel();
    }

    @Override
    public int currentRepetitionLevel() {
        this.advance();
        return this.pageIterator.currentRepetitionLevel();
    }

    @Override
    public boolean nextBoolean() {
        ++this.triplesRead;
        this.advance();
        return this.pageIterator.nextBoolean();
    }

    @Override
    public int nextInteger() {
        ++this.triplesRead;
        this.advance();
        return this.pageIterator.nextInteger();
    }

    @Override
    public long nextLong() {
        ++this.triplesRead;
        this.advance();
        return this.pageIterator.nextLong();
    }

    @Override
    public float nextFloat() {
        ++this.triplesRead;
        this.advance();
        return this.pageIterator.nextFloat();
    }

    @Override
    public double nextDouble() {
        ++this.triplesRead;
        this.advance();
        return this.pageIterator.nextDouble();
    }

    @Override
    public Binary nextBinary() {
        ++this.triplesRead;
        this.advance();
        return this.pageIterator.nextBinary();
    }

    @Override
    public <N> N nextNull() {
        ++this.triplesRead;
        this.advance();
        return (N)this.pageIterator.nextNull();
    }

    @Override
    protected BasePageIterator pageIterator() {
        return this.pageIterator;
    }
}

