/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.rest.HTTPHeaders;
import org.apache.iceberg.rest.HTTPRequest;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="HTTPRequest", generator="Immutables")
@Immutable
public final class ImmutableHTTPRequest
implements HTTPRequest {
    @Nullable
    private final URI baseUri;
    private final HTTPRequest.HTTPMethod method;
    private final String path;
    private final Map<String, String> queryParameters;
    private final HTTPHeaders headers;
    @Nullable
    private final Object body;
    private final ObjectMapper mapper;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private volatile transient long lazyInitBitmap;
    private static final long REQUEST_URI_LAZY_INIT_BIT = 1L;
    private transient URI requestUri;
    private static final long ENCODED_BODY_LAZY_INIT_BIT = 2L;
    private transient String encodedBody;

    private ImmutableHTTPRequest(Builder builder) {
        this.baseUri = builder.baseUri;
        this.method = builder.method;
        this.path = builder.path;
        this.queryParameters = ImmutableHTTPRequest.createUnmodifiableMap(false, false, builder.queryParameters);
        this.body = builder.body;
        if (builder.headers != null) {
            this.initShim.headers(builder.headers);
        }
        if (builder.mapper != null) {
            this.initShim.mapper(builder.mapper);
        }
        this.headers = this.initShim.headers();
        this.mapper = this.initShim.mapper();
        this.initShim = null;
    }

    private ImmutableHTTPRequest(@Nullable URI baseUri, HTTPRequest.HTTPMethod method, String path, Map<String, String> queryParameters, HTTPHeaders headers, @Nullable Object body, ObjectMapper mapper) {
        this.baseUri = baseUri;
        this.method = method;
        this.path = path;
        this.queryParameters = queryParameters;
        this.headers = headers;
        this.body = body;
        this.mapper = mapper;
        this.initShim = null;
    }

    private HTTPHeaders headersInitialize() {
        return HTTPRequest.super.headers();
    }

    private ObjectMapper mapperInitialize() {
        return HTTPRequest.super.mapper();
    }

    @Override
    @Nullable
    public URI baseUri() {
        return this.baseUri;
    }

    @Override
    public HTTPRequest.HTTPMethod method() {
        return this.method;
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public Map<String, String> queryParameters() {
        return this.queryParameters;
    }

    @Override
    public HTTPHeaders headers() {
        InitShim shim = this.initShim;
        return shim != null ? shim.headers() : this.headers;
    }

    @Override
    @Nullable
    public Object body() {
        return this.body;
    }

    @Override
    public ObjectMapper mapper() {
        InitShim shim = this.initShim;
        return shim != null ? shim.mapper() : this.mapper;
    }

    public final ImmutableHTTPRequest withBaseUri(@Nullable URI value) {
        if (this.baseUri == value) {
            return this;
        }
        return ImmutableHTTPRequest.validate(new ImmutableHTTPRequest(value, this.method, this.path, this.queryParameters, this.headers, this.body, this.mapper));
    }

    public final ImmutableHTTPRequest withMethod(HTTPRequest.HTTPMethod value) {
        HTTPRequest.HTTPMethod newValue = Objects.requireNonNull(value, "method");
        if (this.method == newValue) {
            return this;
        }
        return ImmutableHTTPRequest.validate(new ImmutableHTTPRequest(this.baseUri, newValue, this.path, this.queryParameters, this.headers, this.body, this.mapper));
    }

    public final ImmutableHTTPRequest withPath(String value) {
        String newValue = Objects.requireNonNull(value, "path");
        if (this.path.equals(newValue)) {
            return this;
        }
        return ImmutableHTTPRequest.validate(new ImmutableHTTPRequest(this.baseUri, this.method, newValue, this.queryParameters, this.headers, this.body, this.mapper));
    }

    public final ImmutableHTTPRequest withQueryParameters(Map<String, ? extends String> entries) {
        if (this.queryParameters == entries) {
            return this;
        }
        Map<String, String> newValue = ImmutableHTTPRequest.createUnmodifiableMap(true, false, entries);
        return ImmutableHTTPRequest.validate(new ImmutableHTTPRequest(this.baseUri, this.method, this.path, newValue, this.headers, this.body, this.mapper));
    }

    public final ImmutableHTTPRequest withHeaders(HTTPHeaders value) {
        if (this.headers == value) {
            return this;
        }
        HTTPHeaders newValue = Objects.requireNonNull(value, "headers");
        return ImmutableHTTPRequest.validate(new ImmutableHTTPRequest(this.baseUri, this.method, this.path, this.queryParameters, newValue, this.body, this.mapper));
    }

    public final ImmutableHTTPRequest withBody(@Nullable Object value) {
        if (this.body == value) {
            return this;
        }
        return ImmutableHTTPRequest.validate(new ImmutableHTTPRequest(this.baseUri, this.method, this.path, this.queryParameters, this.headers, value, this.mapper));
    }

    public final ImmutableHTTPRequest withMapper(ObjectMapper value) {
        if (this.mapper == value) {
            return this;
        }
        ObjectMapper newValue = Objects.requireNonNull(value, "mapper");
        return ImmutableHTTPRequest.validate(new ImmutableHTTPRequest(this.baseUri, this.method, this.path, this.queryParameters, this.headers, this.body, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableHTTPRequest && this.equalTo(0, (ImmutableHTTPRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableHTTPRequest another) {
        return Objects.equals(this.baseUri, another.baseUri) && this.method.equals((Object)another.method) && this.path.equals(another.path) && this.queryParameters.equals(another.queryParameters) && this.headers.equals(another.headers) && Objects.equals(this.body, another.body) && this.mapper.equals(another.mapper);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.baseUri);
        h += (h << 5) + this.method.hashCode();
        h += (h << 5) + this.path.hashCode();
        h += (h << 5) + this.queryParameters.hashCode();
        h += (h << 5) + this.headers.hashCode();
        h += (h << 5) + Objects.hashCode(this.body);
        h += (h << 5) + this.mapper.hashCode();
        return h;
    }

    public String toString() {
        return "HTTPRequest{baseUri=" + String.valueOf(this.baseUri) + ", method=" + String.valueOf((Object)this.method) + ", path=" + this.path + ", queryParameters=" + String.valueOf(this.queryParameters) + ", headers=" + String.valueOf(this.headers) + ", body=****, mapper=" + String.valueOf(this.mapper) + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URI requestUri() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableHTTPRequest immutableHTTPRequest = this;
            synchronized (immutableHTTPRequest) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.requestUri = Objects.requireNonNull(HTTPRequest.super.requestUri(), "requestUri");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.requestUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String encodedBody() {
        if ((this.lazyInitBitmap & 2L) == 0L) {
            ImmutableHTTPRequest immutableHTTPRequest = this;
            synchronized (immutableHTTPRequest) {
                if ((this.lazyInitBitmap & 2L) == 0L) {
                    this.encodedBody = HTTPRequest.super.encodedBody();
                    this.lazyInitBitmap |= 2L;
                }
            }
        }
        return this.encodedBody;
    }

    private static ImmutableHTTPRequest validate(ImmutableHTTPRequest instance) {
        instance.check();
        return instance;
    }

    public static ImmutableHTTPRequest copyOf(HTTPRequest instance) {
        if (instance instanceof ImmutableHTTPRequest) {
            return (ImmutableHTTPRequest)instance;
        }
        return ImmutableHTTPRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="HTTPRequest", generator="Immutables")
    private final class InitShim {
        private byte headersBuildStage = 0;
        private HTTPHeaders headers;
        private byte mapperBuildStage = 0;
        private ObjectMapper mapper;

        private InitShim() {
        }

        HTTPHeaders headers() {
            if (this.headersBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.headersBuildStage == 0) {
                this.headersBuildStage = (byte)-1;
                this.headers = Objects.requireNonNull(ImmutableHTTPRequest.this.headersInitialize(), "headers");
                this.headersBuildStage = 1;
            }
            return this.headers;
        }

        void headers(HTTPHeaders headers) {
            this.headers = headers;
            this.headersBuildStage = 1;
        }

        ObjectMapper mapper() {
            if (this.mapperBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.mapperBuildStage == 0) {
                this.mapperBuildStage = (byte)-1;
                this.mapper = Objects.requireNonNull(ImmutableHTTPRequest.this.mapperInitialize(), "mapper");
                this.mapperBuildStage = 1;
            }
            return this.mapper;
        }

        void mapper(ObjectMapper mapper) {
            this.mapper = mapper;
            this.mapperBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.headersBuildStage == -1) {
                attributes.add("headers");
            }
            if (this.mapperBuildStage == -1) {
                attributes.add("mapper");
            }
            return "Cannot build HTTPRequest, attribute initializers form cycle " + String.valueOf(attributes);
        }
    }

    @Generated(from="HTTPRequest", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_METHOD = 1L;
        private static final long INIT_BIT_PATH = 2L;
        private long initBits = 3L;
        @Nullable
        private URI baseUri;
        @Nullable
        private HTTPRequest.HTTPMethod method;
        @Nullable
        private String path;
        private Map<String, String> queryParameters = new LinkedHashMap<String, String>();
        @Nullable
        private HTTPHeaders headers;
        @Nullable
        private Object body;
        @Nullable
        private ObjectMapper mapper;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(HTTPRequest instance) {
            Objects.requireNonNull(instance, "instance");
            URI baseUriValue = instance.baseUri();
            if (baseUriValue != null) {
                this.baseUri(baseUriValue);
            }
            this.method(instance.method());
            this.path(instance.path());
            this.putAllQueryParameters(instance.queryParameters());
            this.headers(instance.headers());
            Object bodyValue = instance.body();
            if (bodyValue != null) {
                this.body(bodyValue);
            }
            this.mapper(instance.mapper());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder baseUri(@Nullable URI baseUri) {
            this.baseUri = baseUri;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder method(HTTPRequest.HTTPMethod method) {
            this.method = Objects.requireNonNull(method, "method");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder path(String path) {
            this.path = Objects.requireNonNull(path, "path");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putQueryParameter(String key, String value) {
            this.queryParameters.put(Objects.requireNonNull(key, "queryParameters key"), Objects.requireNonNull(value, value == null ? "queryParameters value for key: " + key : null));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putQueryParameter(Map.Entry<String, ? extends String> entry) {
            String v;
            String k = entry.getKey();
            this.queryParameters.put(Objects.requireNonNull(k, "queryParameters key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "queryParameters value for key: " + k : null));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder queryParameters(Map<String, ? extends String> entries) {
            this.queryParameters.clear();
            return this.putAllQueryParameters(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllQueryParameters(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String v;
                String k = e.getKey();
                this.queryParameters.put(Objects.requireNonNull(k, "queryParameters key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "queryParameters value for key: " + k : null));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder headers(HTTPHeaders headers) {
            this.headers = Objects.requireNonNull(headers, "headers");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder body(@Nullable Object body) {
            this.body = body;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder mapper(ObjectMapper mapper) {
            this.mapper = Objects.requireNonNull(mapper, "mapper");
            return this;
        }

        public ImmutableHTTPRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableHTTPRequest.validate(new ImmutableHTTPRequest(this));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("method");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("path");
            }
            return "Cannot build HTTPRequest, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

