/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.EnclosedInStringPropertiesCopier;
import software.amazon.awssdk.services.glue.model.ParamType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TransformConfigParameter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TransformConfigParameter> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(TransformConfigParameter.getter(TransformConfigParameter::name)).setter(TransformConfigParameter.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(TransformConfigParameter.getter(TransformConfigParameter::typeAsString)).setter(TransformConfigParameter.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> VALIDATION_RULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ValidationRule").getter(TransformConfigParameter.getter(TransformConfigParameter::validationRule)).setter(TransformConfigParameter.setter(Builder::validationRule)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationRule").build()}).build();
    private static final SdkField<String> VALIDATION_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ValidationMessage").getter(TransformConfigParameter.getter(TransformConfigParameter::validationMessage)).setter(TransformConfigParameter.setter(Builder::validationMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationMessage").build()}).build();
    private static final SdkField<List<String>> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Value").getter(TransformConfigParameter.getter(TransformConfigParameter::value)).setter(TransformConfigParameter.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LIST_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ListType").getter(TransformConfigParameter.getter(TransformConfigParameter::listTypeAsString)).setter(TransformConfigParameter.setter(Builder::listType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListType").build()}).build();
    private static final SdkField<Boolean> IS_OPTIONAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsOptional").getter(TransformConfigParameter.getter(TransformConfigParameter::isOptional)).setter(TransformConfigParameter.setter(Builder::isOptional)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsOptional").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TYPE_FIELD, VALIDATION_RULE_FIELD, VALIDATION_MESSAGE_FIELD, VALUE_FIELD, LIST_TYPE_FIELD, IS_OPTIONAL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TransformConfigParameter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String type;
    private final String validationRule;
    private final String validationMessage;
    private final List<String> value;
    private final String listType;
    private final Boolean isOptional;

    private TransformConfigParameter(BuilderImpl builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.validationRule = builder.validationRule;
        this.validationMessage = builder.validationMessage;
        this.value = builder.value;
        this.listType = builder.listType;
        this.isOptional = builder.isOptional;
    }

    public final String name() {
        return this.name;
    }

    public final ParamType type() {
        return ParamType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String validationRule() {
        return this.validationRule;
    }

    public final String validationMessage() {
        return this.validationMessage;
    }

    public final boolean hasValue() {
        return this.value != null && !(this.value instanceof SdkAutoConstructList);
    }

    public final List<String> value() {
        return this.value;
    }

    public final ParamType listType() {
        return ParamType.fromValue(this.listType);
    }

    public final String listTypeAsString() {
        return this.listType;
    }

    public final Boolean isOptional() {
        return this.isOptional;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationRule());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValue() ? this.value() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.listTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.isOptional());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransformConfigParameter)) {
            return false;
        }
        TransformConfigParameter other = (TransformConfigParameter)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.validationRule(), other.validationRule()) && Objects.equals(this.validationMessage(), other.validationMessage()) && this.hasValue() == other.hasValue() && Objects.equals(this.value(), other.value()) && Objects.equals(this.listTypeAsString(), other.listTypeAsString()) && Objects.equals(this.isOptional(), other.isOptional());
    }

    public final String toString() {
        return ToString.builder((String)"TransformConfigParameter").add("Name", (Object)this.name()).add("Type", (Object)this.typeAsString()).add("ValidationRule", (Object)this.validationRule()).add("ValidationMessage", (Object)this.validationMessage()).add("Value", this.hasValue() ? this.value() : null).add("ListType", (Object)this.listTypeAsString()).add("IsOptional", (Object)this.isOptional()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "ValidationRule": {
                return Optional.ofNullable(clazz.cast(this.validationRule()));
            }
            case "ValidationMessage": {
                return Optional.ofNullable(clazz.cast(this.validationMessage()));
            }
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "ListType": {
                return Optional.ofNullable(clazz.cast(this.listTypeAsString()));
            }
            case "IsOptional": {
                return Optional.ofNullable(clazz.cast(this.isOptional()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("ValidationRule", VALIDATION_RULE_FIELD);
        map.put("ValidationMessage", VALIDATION_MESSAGE_FIELD);
        map.put("Value", VALUE_FIELD);
        map.put("ListType", LIST_TYPE_FIELD);
        map.put("IsOptional", IS_OPTIONAL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TransformConfigParameter, T> g) {
        return obj -> g.apply((TransformConfigParameter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String type;
        private String validationRule;
        private String validationMessage;
        private List<String> value = DefaultSdkAutoConstructList.getInstance();
        private String listType;
        private Boolean isOptional;

        private BuilderImpl() {
        }

        private BuilderImpl(TransformConfigParameter model) {
            this.name(model.name);
            this.type(model.type);
            this.validationRule(model.validationRule);
            this.validationMessage(model.validationMessage);
            this.value(model.value);
            this.listType(model.listType);
            this.isOptional(model.isOptional);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ParamType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getValidationRule() {
            return this.validationRule;
        }

        public final void setValidationRule(String validationRule) {
            this.validationRule = validationRule;
        }

        @Override
        public final Builder validationRule(String validationRule) {
            this.validationRule = validationRule;
            return this;
        }

        public final String getValidationMessage() {
            return this.validationMessage;
        }

        public final void setValidationMessage(String validationMessage) {
            this.validationMessage = validationMessage;
        }

        @Override
        public final Builder validationMessage(String validationMessage) {
            this.validationMessage = validationMessage;
            return this;
        }

        public final Collection<String> getValue() {
            if (this.value instanceof SdkAutoConstructList) {
                return null;
            }
            return this.value;
        }

        public final void setValue(Collection<String> value) {
            this.value = EnclosedInStringPropertiesCopier.copy(value);
        }

        @Override
        public final Builder value(Collection<String> value) {
            this.value = EnclosedInStringPropertiesCopier.copy(value);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder value(String ... value) {
            this.value(Arrays.asList(value));
            return this;
        }

        public final String getListType() {
            return this.listType;
        }

        public final void setListType(String listType) {
            this.listType = listType;
        }

        @Override
        public final Builder listType(String listType) {
            this.listType = listType;
            return this;
        }

        @Override
        public final Builder listType(ParamType listType) {
            this.listType(listType == null ? null : listType.toString());
            return this;
        }

        public final Boolean getIsOptional() {
            return this.isOptional;
        }

        public final void setIsOptional(Boolean isOptional) {
            this.isOptional = isOptional;
        }

        @Override
        public final Builder isOptional(Boolean isOptional) {
            this.isOptional = isOptional;
            return this;
        }

        public TransformConfigParameter build() {
            return new TransformConfigParameter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TransformConfigParameter> {
        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(ParamType var1);

        public Builder validationRule(String var1);

        public Builder validationMessage(String var1);

        public Builder value(Collection<String> var1);

        public Builder value(String ... var1);

        public Builder listType(String var1);

        public Builder listType(ParamType var1);

        public Builder isOptional(Boolean var1);
    }
}

