/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.DataSource;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartDataQualityRuleRecommendationRunRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, StartDataQualityRuleRecommendationRunRequest> {
    private static final SdkField<DataSource> DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataSource").getter(StartDataQualityRuleRecommendationRunRequest.getter(StartDataQualityRuleRecommendationRunRequest::dataSource)).setter(StartDataQualityRuleRecommendationRunRequest.setter(Builder::dataSource)).constructor(DataSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSource").build()}).build();
    private static final SdkField<String> ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Role").getter(StartDataQualityRuleRecommendationRunRequest.getter(StartDataQualityRuleRecommendationRunRequest::role)).setter(StartDataQualityRuleRecommendationRunRequest.setter(Builder::role)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_WORKERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfWorkers").getter(StartDataQualityRuleRecommendationRunRequest.getter(StartDataQualityRuleRecommendationRunRequest::numberOfWorkers)).setter(StartDataQualityRuleRecommendationRunRequest.setter(Builder::numberOfWorkers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfWorkers").build()}).build();
    private static final SdkField<Integer> TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Timeout").getter(StartDataQualityRuleRecommendationRunRequest.getter(StartDataQualityRuleRecommendationRunRequest::timeout)).setter(StartDataQualityRuleRecommendationRunRequest.setter(Builder::timeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timeout").build()}).build();
    private static final SdkField<String> CREATED_RULESET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatedRulesetName").getter(StartDataQualityRuleRecommendationRunRequest.getter(StartDataQualityRuleRecommendationRunRequest::createdRulesetName)).setter(StartDataQualityRuleRecommendationRunRequest.setter(Builder::createdRulesetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedRulesetName").build()}).build();
    private static final SdkField<String> DATA_QUALITY_SECURITY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataQualitySecurityConfiguration").getter(StartDataQualityRuleRecommendationRunRequest.getter(StartDataQualityRuleRecommendationRunRequest::dataQualitySecurityConfiguration)).setter(StartDataQualityRuleRecommendationRunRequest.setter(Builder::dataQualitySecurityConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataQualitySecurityConfiguration").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(StartDataQualityRuleRecommendationRunRequest.getter(StartDataQualityRuleRecommendationRunRequest::clientToken)).setter(StartDataQualityRuleRecommendationRunRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_FIELD, ROLE_FIELD, NUMBER_OF_WORKERS_FIELD, TIMEOUT_FIELD, CREATED_RULESET_NAME_FIELD, DATA_QUALITY_SECURITY_CONFIGURATION_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartDataQualityRuleRecommendationRunRequest.memberNameToFieldInitializer();
    private final DataSource dataSource;
    private final String role;
    private final Integer numberOfWorkers;
    private final Integer timeout;
    private final String createdRulesetName;
    private final String dataQualitySecurityConfiguration;
    private final String clientToken;

    private StartDataQualityRuleRecommendationRunRequest(BuilderImpl builder) {
        super(builder);
        this.dataSource = builder.dataSource;
        this.role = builder.role;
        this.numberOfWorkers = builder.numberOfWorkers;
        this.timeout = builder.timeout;
        this.createdRulesetName = builder.createdRulesetName;
        this.dataQualitySecurityConfiguration = builder.dataQualitySecurityConfiguration;
        this.clientToken = builder.clientToken;
    }

    public final DataSource dataSource() {
        return this.dataSource;
    }

    public final String role() {
        return this.role;
    }

    public final Integer numberOfWorkers() {
        return this.numberOfWorkers;
    }

    public final Integer timeout() {
        return this.timeout;
    }

    public final String createdRulesetName() {
        return this.createdRulesetName;
    }

    public final String dataQualitySecurityConfiguration() {
        return this.dataQualitySecurityConfiguration;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.role());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfWorkers());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdRulesetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataQualitySecurityConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartDataQualityRuleRecommendationRunRequest)) {
            return false;
        }
        StartDataQualityRuleRecommendationRunRequest other = (StartDataQualityRuleRecommendationRunRequest)((Object)obj);
        return Objects.equals(this.dataSource(), other.dataSource()) && Objects.equals(this.role(), other.role()) && Objects.equals(this.numberOfWorkers(), other.numberOfWorkers()) && Objects.equals(this.timeout(), other.timeout()) && Objects.equals(this.createdRulesetName(), other.createdRulesetName()) && Objects.equals(this.dataQualitySecurityConfiguration(), other.dataQualitySecurityConfiguration()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"StartDataQualityRuleRecommendationRunRequest").add("DataSource", (Object)this.dataSource()).add("Role", (Object)this.role()).add("NumberOfWorkers", (Object)this.numberOfWorkers()).add("Timeout", (Object)this.timeout()).add("CreatedRulesetName", (Object)this.createdRulesetName()).add("DataQualitySecurityConfiguration", (Object)this.dataQualitySecurityConfiguration()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataSource": {
                return Optional.ofNullable(clazz.cast(this.dataSource()));
            }
            case "Role": {
                return Optional.ofNullable(clazz.cast(this.role()));
            }
            case "NumberOfWorkers": {
                return Optional.ofNullable(clazz.cast(this.numberOfWorkers()));
            }
            case "Timeout": {
                return Optional.ofNullable(clazz.cast(this.timeout()));
            }
            case "CreatedRulesetName": {
                return Optional.ofNullable(clazz.cast(this.createdRulesetName()));
            }
            case "DataQualitySecurityConfiguration": {
                return Optional.ofNullable(clazz.cast(this.dataQualitySecurityConfiguration()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DataSource", DATA_SOURCE_FIELD);
        map.put("Role", ROLE_FIELD);
        map.put("NumberOfWorkers", NUMBER_OF_WORKERS_FIELD);
        map.put("Timeout", TIMEOUT_FIELD);
        map.put("CreatedRulesetName", CREATED_RULESET_NAME_FIELD);
        map.put("DataQualitySecurityConfiguration", DATA_QUALITY_SECURITY_CONFIGURATION_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartDataQualityRuleRecommendationRunRequest, T> g) {
        return obj -> g.apply((StartDataQualityRuleRecommendationRunRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private DataSource dataSource;
        private String role;
        private Integer numberOfWorkers;
        private Integer timeout;
        private String createdRulesetName;
        private String dataQualitySecurityConfiguration;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StartDataQualityRuleRecommendationRunRequest model) {
            super(model);
            this.dataSource(model.dataSource);
            this.role(model.role);
            this.numberOfWorkers(model.numberOfWorkers);
            this.timeout(model.timeout);
            this.createdRulesetName(model.createdRulesetName);
            this.dataQualitySecurityConfiguration(model.dataQualitySecurityConfiguration);
            this.clientToken(model.clientToken);
        }

        public final DataSource.Builder getDataSource() {
            return this.dataSource != null ? this.dataSource.toBuilder() : null;
        }

        public final void setDataSource(DataSource.BuilderImpl dataSource) {
            this.dataSource = dataSource != null ? dataSource.build() : null;
        }

        @Override
        public final Builder dataSource(DataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final String getRole() {
            return this.role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final Integer getNumberOfWorkers() {
            return this.numberOfWorkers;
        }

        public final void setNumberOfWorkers(Integer numberOfWorkers) {
            this.numberOfWorkers = numberOfWorkers;
        }

        @Override
        public final Builder numberOfWorkers(Integer numberOfWorkers) {
            this.numberOfWorkers = numberOfWorkers;
            return this;
        }

        public final Integer getTimeout() {
            return this.timeout;
        }

        public final void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        @Override
        public final Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public final String getCreatedRulesetName() {
            return this.createdRulesetName;
        }

        public final void setCreatedRulesetName(String createdRulesetName) {
            this.createdRulesetName = createdRulesetName;
        }

        @Override
        public final Builder createdRulesetName(String createdRulesetName) {
            this.createdRulesetName = createdRulesetName;
            return this;
        }

        public final String getDataQualitySecurityConfiguration() {
            return this.dataQualitySecurityConfiguration;
        }

        public final void setDataQualitySecurityConfiguration(String dataQualitySecurityConfiguration) {
            this.dataQualitySecurityConfiguration = dataQualitySecurityConfiguration;
        }

        @Override
        public final Builder dataQualitySecurityConfiguration(String dataQualitySecurityConfiguration) {
            this.dataQualitySecurityConfiguration = dataQualitySecurityConfiguration;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartDataQualityRuleRecommendationRunRequest build() {
            return new StartDataQualityRuleRecommendationRunRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartDataQualityRuleRecommendationRunRequest> {
        public Builder dataSource(DataSource var1);

        default public Builder dataSource(Consumer<DataSource.Builder> dataSource) {
            return this.dataSource((DataSource)((DataSource.Builder)DataSource.builder().applyMutation(dataSource)).build());
        }

        public Builder role(String var1);

        public Builder numberOfWorkers(Integer var1);

        public Builder timeout(Integer var1);

        public Builder createdRulesetName(String var1);

        public Builder dataQualitySecurityConfiguration(String var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

