/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.OneInputCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FillMissingValues
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FillMissingValues> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(FillMissingValues.getter(FillMissingValues::name)).setter(FillMissingValues.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<String>> INPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Inputs").getter(FillMissingValues.getter(FillMissingValues::inputs)).setter(FillMissingValues.setter(Builder::inputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Inputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> IMPUTED_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImputedPath").getter(FillMissingValues.getter(FillMissingValues::imputedPath)).setter(FillMissingValues.setter(Builder::imputedPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImputedPath").build()}).build();
    private static final SdkField<String> FILLED_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FilledPath").getter(FillMissingValues.getter(FillMissingValues::filledPath)).setter(FillMissingValues.setter(Builder::filledPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilledPath").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, INPUTS_FIELD, IMPUTED_PATH_FIELD, FILLED_PATH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FillMissingValues.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final List<String> inputs;
    private final String imputedPath;
    private final String filledPath;

    private FillMissingValues(BuilderImpl builder) {
        this.name = builder.name;
        this.inputs = builder.inputs;
        this.imputedPath = builder.imputedPath;
        this.filledPath = builder.filledPath;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasInputs() {
        return this.inputs != null && !(this.inputs instanceof SdkAutoConstructList);
    }

    public final List<String> inputs() {
        return this.inputs;
    }

    public final String imputedPath() {
        return this.imputedPath;
    }

    public final String filledPath() {
        return this.filledPath;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputs() ? this.inputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.imputedPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.filledPath());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FillMissingValues)) {
            return false;
        }
        FillMissingValues other = (FillMissingValues)obj;
        return Objects.equals(this.name(), other.name()) && this.hasInputs() == other.hasInputs() && Objects.equals(this.inputs(), other.inputs()) && Objects.equals(this.imputedPath(), other.imputedPath()) && Objects.equals(this.filledPath(), other.filledPath());
    }

    public final String toString() {
        return ToString.builder((String)"FillMissingValues").add("Name", (Object)this.name()).add("Inputs", this.hasInputs() ? this.inputs() : null).add("ImputedPath", (Object)this.imputedPath()).add("FilledPath", (Object)this.filledPath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Inputs": {
                return Optional.ofNullable(clazz.cast(this.inputs()));
            }
            case "ImputedPath": {
                return Optional.ofNullable(clazz.cast(this.imputedPath()));
            }
            case "FilledPath": {
                return Optional.ofNullable(clazz.cast(this.filledPath()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Inputs", INPUTS_FIELD);
        map.put("ImputedPath", IMPUTED_PATH_FIELD);
        map.put("FilledPath", FILLED_PATH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FillMissingValues, T> g) {
        return obj -> g.apply((FillMissingValues)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private List<String> inputs = DefaultSdkAutoConstructList.getInstance();
        private String imputedPath;
        private String filledPath;

        private BuilderImpl() {
        }

        private BuilderImpl(FillMissingValues model) {
            this.name(model.name);
            this.inputs(model.inputs);
            this.imputedPath(model.imputedPath);
            this.filledPath(model.filledPath);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getInputs() {
            if (this.inputs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.inputs;
        }

        public final void setInputs(Collection<String> inputs) {
            this.inputs = OneInputCopier.copy(inputs);
        }

        @Override
        public final Builder inputs(Collection<String> inputs) {
            this.inputs = OneInputCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(String ... inputs) {
            this.inputs(Arrays.asList(inputs));
            return this;
        }

        public final String getImputedPath() {
            return this.imputedPath;
        }

        public final void setImputedPath(String imputedPath) {
            this.imputedPath = imputedPath;
        }

        @Override
        public final Builder imputedPath(String imputedPath) {
            this.imputedPath = imputedPath;
            return this;
        }

        public final String getFilledPath() {
            return this.filledPath;
        }

        public final void setFilledPath(String filledPath) {
            this.filledPath = filledPath;
        }

        @Override
        public final Builder filledPath(String filledPath) {
            this.filledPath = filledPath;
            return this;
        }

        public FillMissingValues build() {
            return new FillMissingValues(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FillMissingValues> {
        public Builder name(String var1);

        public Builder inputs(Collection<String> var1);

        public Builder inputs(String ... var1);

        public Builder imputedPath(String var1);

        public Builder filledPath(String var1);
    }
}

