/*
 * Decompiled with CFR 0.152.
 */
package org.debezium.connector.mongodb.transforms;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.data.Timestamp;
import org.apache.kafka.connect.errors.DataException;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.debezium.connector.mongodb.transforms.ArrayEncoding;

public class MongoDataConverter {
    public static final String SCHEMA_NAME_REGEX = "io.debezium.mongodb.regex";
    private final ArrayEncoding arrayEncoding;

    public MongoDataConverter(ArrayEncoding arrayEncoding) {
        this.arrayEncoding = arrayEncoding;
    }

    public Struct convertRecord(Map.Entry<String, BsonValue> keyValueForStruct, Schema schema, Struct struct) {
        this.convertFieldValue(keyValueForStruct, struct, schema);
        return struct;
    }

    public void convertFieldValue(Map.Entry<String, BsonValue> keyValueForStruct, Struct struct, Schema schema) {
        Object colValue = null;
        String key = keyValueForStruct.getKey();
        BsonType type = keyValueForStruct.getValue().getBsonType();
        switch (type) {
            case NULL: {
                colValue = null;
                break;
            }
            case STRING: {
                colValue = keyValueForStruct.getValue().asString().getValue().toString();
                break;
            }
            case OBJECT_ID: {
                colValue = keyValueForStruct.getValue().asObjectId().getValue().toString();
                break;
            }
            case DOUBLE: {
                colValue = keyValueForStruct.getValue().asDouble().getValue();
                break;
            }
            case BINARY: {
                colValue = keyValueForStruct.getValue().asBinary().getData();
                break;
            }
            case INT32: {
                colValue = keyValueForStruct.getValue().asInt32().getValue();
                break;
            }
            case INT64: {
                colValue = keyValueForStruct.getValue().asInt64().getValue();
                break;
            }
            case BOOLEAN: {
                colValue = keyValueForStruct.getValue().asBoolean().getValue();
                break;
            }
            case DATE_TIME: {
                colValue = new Date(keyValueForStruct.getValue().asDateTime().getValue());
                break;
            }
            case JAVASCRIPT: {
                colValue = keyValueForStruct.getValue().asJavaScript().getCode();
                break;
            }
            case JAVASCRIPT_WITH_SCOPE: {
                Struct jsStruct = new Struct(schema.field(key).schema());
                Struct jsScopeStruct = new Struct(schema.field(key).schema().field("scope").schema());
                jsStruct.put("code", (Object)keyValueForStruct.getValue().asJavaScriptWithScope().getCode());
                BsonDocument jwsDoc = keyValueForStruct.getValue().asJavaScriptWithScope().getScope().asDocument();
                for (Map.Entry jwsDocKey : jwsDoc.entrySet()) {
                    this.convertFieldValue(jwsDocKey, jsScopeStruct, schema.field(key).schema());
                }
                jsStruct.put("scope", (Object)jsScopeStruct);
                colValue = jsStruct;
                break;
            }
            case REGULAR_EXPRESSION: {
                Struct regexStruct = new Struct(schema.field(key).schema());
                regexStruct.put("regex", (Object)keyValueForStruct.getValue().asRegularExpression().getPattern());
                regexStruct.put("options", (Object)keyValueForStruct.getValue().asRegularExpression().getOptions());
                colValue = regexStruct;
                break;
            }
            case TIMESTAMP: {
                colValue = new Date(1000L * (long)keyValueForStruct.getValue().asTimestamp().getTime());
                break;
            }
            case DECIMAL128: {
                colValue = keyValueForStruct.getValue().asDecimal128().getValue().toString();
                break;
            }
            case DOCUMENT: {
                Field field = schema.field(key);
                if (field == null) {
                    throw new DataException("Failed to find field '" + key + "' in schema " + schema.name());
                }
                Schema documentSchema = field.schema();
                Struct documentStruct = new Struct(documentSchema);
                BsonDocument docs = keyValueForStruct.getValue().asDocument();
                for (Map.Entry doc : docs.entrySet()) {
                    this.convertFieldValue(doc, documentStruct, documentSchema);
                }
                colValue = documentStruct;
                break;
            }
            case ARRAY: {
                if (keyValueForStruct.getValue().asArray().isEmpty()) {
                    switch (this.arrayEncoding) {
                        case ARRAY: {
                            colValue = Lists.newArrayList();
                            break;
                        }
                        case DOCUMENT: {
                            Schema fieldSchema = schema.field(key).schema();
                            colValue = new Struct(fieldSchema);
                        }
                    }
                    break;
                }
                switch (this.arrayEncoding) {
                    case ARRAY: {
                        BsonType valueType = keyValueForStruct.getValue().asArray().get(0).getBsonType();
                        List arrValues = keyValueForStruct.getValue().asArray().getValues();
                        ArrayList list = Lists.newArrayList();
                        arrValues.forEach(arrValue -> {
                            Schema valueSchema = Arrays.asList(BsonType.ARRAY, BsonType.DOCUMENT).contains(valueType) ? schema.field(key).schema().valueSchema() : null;
                            this.convertFieldValue(valueSchema, valueType, (BsonValue)arrValue, list);
                        });
                        colValue = list;
                        break;
                    }
                    case DOCUMENT: {
                        BsonArray array = keyValueForStruct.getValue().asArray();
                        HashMap convertedArray = Maps.newHashMap();
                        Schema arraySchema = schema.field(key).schema();
                        Struct arrayStruct = new Struct(arraySchema);
                        for (int i = 0; i < array.size(); ++i) {
                            convertedArray.put(this.arrayElementStructName(i), array.get(i));
                        }
                        convertedArray.entrySet().forEach(x -> {
                            Schema elementSchema = schema.field(key).schema();
                            this.convertFieldValue((Map.Entry<String, BsonValue>)x, arrayStruct, elementSchema);
                        });
                        colValue = arrayStruct;
                    }
                }
                break;
            }
            default: {
                return;
            }
        }
        struct.put(key, keyValueForStruct.getValue().isNull() ? null : colValue);
    }

    private void convertFieldValue(Schema valueSchema, BsonType valueType, BsonValue arrValue, List<Object> list) {
        if (arrValue.getBsonType() == BsonType.STRING && valueType == BsonType.STRING) {
            String temp = arrValue.asString().getValue();
            list.add(temp);
        } else if (arrValue.getBsonType() == BsonType.JAVASCRIPT && valueType == BsonType.JAVASCRIPT) {
            String temp = arrValue.asJavaScript().getCode();
            list.add(temp);
        } else if (arrValue.getBsonType() == BsonType.OBJECT_ID && valueType == BsonType.OBJECT_ID) {
            String temp = arrValue.asObjectId().getValue().toString();
            list.add(temp);
        } else if (arrValue.getBsonType() == BsonType.DOUBLE && valueType == BsonType.DOUBLE) {
            double temp = arrValue.asDouble().getValue();
            list.add(temp);
        } else if (arrValue.getBsonType() == BsonType.BINARY && valueType == BsonType.BINARY) {
            byte[] temp = arrValue.asBinary().getData();
            list.add(temp);
        } else if (arrValue.getBsonType() == BsonType.INT32 && valueType == BsonType.INT32) {
            int temp = arrValue.asInt32().getValue();
            list.add(temp);
        } else if (arrValue.getBsonType() == BsonType.INT64 && valueType == BsonType.INT64) {
            long temp = arrValue.asInt64().getValue();
            list.add(temp);
        } else if (arrValue.getBsonType() == BsonType.DATE_TIME && valueType == BsonType.DATE_TIME) {
            Date temp = new Date(arrValue.asInt64().getValue());
            list.add(temp);
        } else if (arrValue.getBsonType() == BsonType.DECIMAL128 && valueType == BsonType.DECIMAL128) {
            String temp = arrValue.asDecimal128().getValue().toString();
            list.add(temp);
        } else if (arrValue.getBsonType() == BsonType.TIMESTAMP && valueType == BsonType.TIMESTAMP) {
            Date temp = new Date(1000L * (long)arrValue.asInt32().getValue());
            list.add(temp);
        } else if (arrValue.getBsonType() == BsonType.BOOLEAN && valueType == BsonType.BOOLEAN) {
            boolean temp = arrValue.asBoolean().getValue();
            list.add(temp);
        } else if (arrValue.getBsonType() == BsonType.DOCUMENT && valueType == BsonType.DOCUMENT) {
            Struct struct1 = new Struct(valueSchema);
            for (Map.Entry entry9 : arrValue.asDocument().entrySet()) {
                this.convertFieldValue(entry9, struct1, valueSchema);
            }
            list.add(struct1);
        } else if (arrValue.getBsonType() == BsonType.ARRAY && valueType == BsonType.ARRAY) {
            ArrayList subList = Lists.newArrayList();
            Schema subValueSchema = Arrays.asList(BsonType.ARRAY, BsonType.DOCUMENT).contains(arrValue.asArray().get(0).getBsonType()) ? valueSchema.valueSchema() : null;
            for (BsonValue v : arrValue.asArray()) {
                this.convertFieldValue(subValueSchema, v.getBsonType(), v, subList);
            }
            list.add(subList);
        }
    }

    protected String arrayElementStructName(int index) {
        return "_" + index;
    }

    public void addFieldSchema(Map.Entry<String, BsonValue> keyValuesForSchema, SchemaBuilder builder) {
        String key = keyValuesForSchema.getKey();
        BsonType type = keyValuesForSchema.getValue().getBsonType();
        switch (type) {
            case NULL: 
            case STRING: 
            case OBJECT_ID: 
            case JAVASCRIPT: 
            case DECIMAL128: {
                builder.field(key, Schema.OPTIONAL_STRING_SCHEMA);
                break;
            }
            case DOUBLE: {
                builder.field(key, Schema.OPTIONAL_FLOAT64_SCHEMA);
                break;
            }
            case BINARY: {
                builder.field(key, Schema.OPTIONAL_BYTES_SCHEMA);
                break;
            }
            case INT32: {
                builder.field(key, Schema.OPTIONAL_INT32_SCHEMA);
                break;
            }
            case INT64: {
                builder.field(key, Schema.OPTIONAL_INT64_SCHEMA);
                break;
            }
            case DATE_TIME: 
            case TIMESTAMP: {
                builder.field(key, Timestamp.builder().optional().build());
                break;
            }
            case BOOLEAN: {
                builder.field(key, Schema.OPTIONAL_BOOLEAN_SCHEMA);
                break;
            }
            case JAVASCRIPT_WITH_SCOPE: {
                SchemaBuilder jsWithScope = SchemaBuilder.struct().name(builder.name() + "." + key);
                jsWithScope.field("code", Schema.OPTIONAL_STRING_SCHEMA);
                SchemaBuilder scope = SchemaBuilder.struct().name(jsWithScope.name() + ".scope").optional();
                BsonDocument jwsDocument = keyValuesForSchema.getValue().asJavaScriptWithScope().getScope().asDocument();
                for (Map.Entry jwsDocumentKey : jwsDocument.entrySet()) {
                    this.addFieldSchema(jwsDocumentKey, scope);
                }
                Schema scopeBuild = scope.build();
                jsWithScope.field("scope", scopeBuild).build();
                builder.field(key, (Schema)jsWithScope);
                break;
            }
            case REGULAR_EXPRESSION: {
                SchemaBuilder regexwop = SchemaBuilder.struct().name(SCHEMA_NAME_REGEX).optional();
                regexwop.field("regex", Schema.OPTIONAL_STRING_SCHEMA);
                regexwop.field("options", Schema.OPTIONAL_STRING_SCHEMA);
                builder.field(key, regexwop.build());
                break;
            }
            case DOCUMENT: {
                SchemaBuilder builderDoc = SchemaBuilder.struct().name(builder.name() + "." + key).optional();
                BsonDocument docs = keyValuesForSchema.getValue().asDocument();
                for (Map.Entry doc : docs.entrySet()) {
                    this.addFieldSchema(doc, builderDoc);
                }
                builder.field(key, builderDoc.build());
                break;
            }
            case ARRAY: {
                if (keyValuesForSchema.getValue().asArray().isEmpty()) {
                    switch (this.arrayEncoding) {
                        case ARRAY: {
                            builder.field(key, SchemaBuilder.array((Schema)Schema.OPTIONAL_STRING_SCHEMA).optional().build());
                            break;
                        }
                        case DOCUMENT: {
                            builder.field(key, SchemaBuilder.struct().name(builder.name() + "." + key).optional().build());
                        }
                    }
                    break;
                }
                switch (this.arrayEncoding) {
                    case ARRAY: {
                        BsonArray value = keyValuesForSchema.getValue().asArray();
                        BsonType valueType = value.get(0).getBsonType();
                        this.testType(builder, key, keyValuesForSchema.getValue(), valueType);
                        builder.field(key, SchemaBuilder.array((Schema)this.subSchema(builder, key, valueType, (BsonValue)value)).optional().build());
                        break;
                    }
                    case DOCUMENT: {
                        BsonArray array = keyValuesForSchema.getValue().asArray();
                        SchemaBuilder arrayStructBuilder = SchemaBuilder.struct().name(builder.name() + "." + key).optional();
                        HashMap convertedArray = Maps.newHashMap();
                        for (int i = 0; i < array.size(); ++i) {
                            convertedArray.put(this.arrayElementStructName(i), array.get(i));
                        }
                        convertedArray.entrySet().forEach(x -> this.addFieldSchema((Map.Entry<String, BsonValue>)x, arrayStructBuilder));
                        builder.field(key, arrayStructBuilder.build());
                    }
                }
                break;
            }
        }
    }

    private Schema subSchema(SchemaBuilder builder, String key, BsonType valueType, BsonValue value) {
        switch (valueType) {
            case NULL: 
            case STRING: 
            case OBJECT_ID: 
            case JAVASCRIPT: 
            case DECIMAL128: {
                return Schema.OPTIONAL_STRING_SCHEMA;
            }
            case DOUBLE: {
                return Schema.OPTIONAL_FLOAT64_SCHEMA;
            }
            case BINARY: {
                return Schema.OPTIONAL_BYTES_SCHEMA;
            }
            case INT32: {
                return Schema.OPTIONAL_INT32_SCHEMA;
            }
            case INT64: {
                return Schema.OPTIONAL_INT64_SCHEMA;
            }
            case DATE_TIME: 
            case TIMESTAMP: {
                return Timestamp.builder().optional().build();
            }
            case BOOLEAN: {
                return Schema.OPTIONAL_BOOLEAN_SCHEMA;
            }
            case DOCUMENT: {
                SchemaBuilder documentSchemaBuilder = SchemaBuilder.struct().name(builder.name() + "." + key).optional();
                HashMap union = Maps.newHashMap();
                if (value.isArray()) {
                    value.asArray().forEach(f -> this.subSchema(documentSchemaBuilder, union, f.asDocument(), true));
                    if (documentSchemaBuilder.fields().isEmpty()) {
                        value.asArray().forEach(f -> this.subSchema(documentSchemaBuilder, union, f.asDocument(), false));
                    }
                } else {
                    this.subSchema(documentSchemaBuilder, union, value.asDocument(), false);
                }
                return documentSchemaBuilder.build();
            }
            case ARRAY: {
                BsonType subValueType = value.asArray().get(0).asArray().get(0).getBsonType();
                return SchemaBuilder.array((Schema)this.subSchema(builder, key, subValueType, value.asArray().get(0))).optional().build();
            }
        }
        throw new IllegalArgumentException("The value type '" + String.valueOf(valueType) + " is not yet supported inside for a subSchema.");
    }

    private void subSchema(SchemaBuilder documentSchemaBuilder, Map<String, BsonType> union, BsonDocument arrayDocs, boolean emptyChecker) {
        for (Map.Entry arrayDoc : arrayDocs.entrySet()) {
            String key = (String)arrayDoc.getKey();
            if (emptyChecker && (arrayDoc.getValue() instanceof BsonDocument && ((BsonDocument)arrayDoc.getValue()).isEmpty() || arrayDoc.getValue() instanceof BsonArray && ((BsonArray)arrayDoc.getValue()).isEmpty())) continue;
            BsonType prevType = union.putIfAbsent(key, ((BsonValue)arrayDoc.getValue()).getBsonType());
            if (prevType == null) {
                this.addFieldSchema(arrayDoc, documentSchemaBuilder);
                continue;
            }
            this.testArrayElementType(documentSchemaBuilder, arrayDoc, union);
        }
    }

    private void testType(SchemaBuilder builder, String key, BsonValue value, BsonType valueType) {
        if (valueType == BsonType.DOCUMENT) {
            HashMap union = Maps.newHashMap();
            for (BsonValue element : value.asArray()) {
                BsonDocument arrayDocs = element.asDocument();
                for (Map.Entry arrayDoc : arrayDocs.entrySet()) {
                    this.testArrayElementType(builder, arrayDoc, union);
                }
            }
        } else if (valueType == BsonType.ARRAY) {
            for (BsonValue element : value.asArray()) {
                BsonType subValueType = element.asArray().get(0).getBsonType();
                this.testType(builder, key, element, subValueType);
            }
        } else {
            for (BsonValue element : value.asArray()) {
                if (element.getBsonType() == valueType) continue;
                throw new RuntimeException("Field " + key + " of schema " + builder.name() + " is not a homogenous array.\nCheck option 'struct' of parameter 'array.encoding'");
            }
        }
    }

    private void testArrayElementType(SchemaBuilder builder, Map.Entry<String, BsonValue> arrayDoc, Map<String, BsonType> union) {
        BsonType currentType;
        String docKey = arrayDoc.getKey();
        BsonType prevType = union.putIfAbsent(docKey, currentType = arrayDoc.getValue().getBsonType());
        if (prevType != null) {
            if (!(prevType != BsonType.NULL && currentType != BsonType.NULL || Objects.equals(prevType, currentType))) {
                if (prevType == BsonType.NULL) {
                    union.put(docKey, currentType);
                }
            } else if (!Objects.equals(prevType, currentType)) {
                throw new RuntimeException("Field " + docKey + " of schema " + builder.name() + " is not the same type for all documents in the array.\nCheck option 'struct' of parameter 'array.encoding'");
            }
        }
    }
}

