/*
 * Decompiled with CFR 0.152.
 */
package org.debezium.connector.mongodb.transforms;

public enum ArrayEncoding {
    ARRAY("array"),
    DOCUMENT("document");

    private final String value;

    private ArrayEncoding(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static ArrayEncoding parse(String value) {
        if (value == null) {
            return null;
        }
        for (ArrayEncoding option : ArrayEncoding.values()) {
            if (!option.getValue().equalsIgnoreCase(value.trim())) continue;
            return option;
        }
        return null;
    }

    public static ArrayEncoding parse(String value, String defaultValue) {
        ArrayEncoding mode = ArrayEncoding.parse(value);
        if (mode == null && defaultValue != null) {
            mode = ArrayEncoding.parse(defaultValue);
        }
        return mode;
    }
}

