/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.connect.transforms;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.sink.SinkRecord;
import org.apache.kafka.connect.transforms.ExtractField;
import org.apache.kafka.connect.transforms.Transformation;
import org.apache.kafka.connect.transforms.util.Requirements;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.debezium.connector.mongodb.transforms.ArrayEncoding;
import org.debezium.connector.mongodb.transforms.MongoDataConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDebeziumTransform
implements Transformation<SinkRecord> {
    public static final String ARRAY_HANDLING_MODE_KEY = "array_handling_mode";
    public static final String RECORD_ENVELOPE_KEY_SCHEMA_NAME_SUFFIX = ".Key";
    public static final String SCHEMA_NAME_SUFFIX = ".Envelope";
    private static final String UPDATE_DESCRIPTION = "updateDescription";
    private static final String REMOVED_FIELDS = "removedFields";
    private static final String UPDATED_FIELDS = "updatedFields";
    private static final String AFTER_FIELD_NAME = "after";
    private static final String BEFORE_FIELD_NAME = "before";
    private final ExtractField<SinkRecord> updateDescriptionExtractor = MongoDebeziumTransform.extractorValueField("updateDescription");
    private final ExtractField<SinkRecord> afterExtractor = MongoDebeziumTransform.extractorValueField("after");
    private final ExtractField<SinkRecord> beforeExtractor = MongoDebeziumTransform.extractorValueField("before");
    private final ExtractField<SinkRecord> keyIdExtractor = MongoDebeziumTransform.extractorForKeyField("id");
    private MongoDataConverter converter;
    private static final Logger LOG = LoggerFactory.getLogger((String)MongoDebeziumTransform.class.getName());
    private static final ConfigDef CONFIG_DEF = new ConfigDef().define("array_handling_mode", ConfigDef.Type.STRING, null, ConfigDef.Importance.MEDIUM, "array or document handling for mongodb arrays");

    public SinkRecord apply(SinkRecord record) {
        if (record.value() == null) {
            return record;
        }
        if (!this.isValidKey(record) || !this.isValidValue(record)) {
            LOG.debug("Expected Key Schema/Envelope for transformation, converting to tombstone. Message key: \"{}\"", record.key());
            return record.newRecord(record.topic(), record.kafkaPartition(), null, null, null, null, record.timestamp(), (Iterable)record.headers());
        }
        SinkRecord keyIdRecord = (SinkRecord)this.keyIdExtractor.apply((ConnectRecord)record);
        SinkRecord afterRecord = (SinkRecord)this.afterExtractor.apply((ConnectRecord)record);
        SinkRecord beforeRecord = (SinkRecord)this.beforeExtractor.apply((ConnectRecord)record);
        SinkRecord updateDescriptionRecord = (SinkRecord)this.updateDescriptionExtractor.apply((ConnectRecord)record);
        if (beforeRecord.value() == null && afterRecord.value() == null && updateDescriptionRecord.value() == null) {
            throw new IllegalArgumentException(String.format("malformed record topic: %s, partition: %s, offset: %s", record.topic(), record.kafkaPartition(), record.kafkaOffset()));
        }
        BsonDocument afterBson = null;
        BsonDocument beforeBson = null;
        BsonDocument keyBson = BsonDocument.parse((String)("{ \"id\" : " + keyIdRecord.key().toString() + "}"));
        if (beforeRecord.value() != null) {
            beforeBson = BsonDocument.parse((String)beforeRecord.value().toString());
        }
        if (afterRecord.value() == null && updateDescriptionRecord.value() != null) {
            afterBson = this.buildAfterBsonFromPartials(updateDescriptionRecord, beforeBson == null ? new BsonDocument() : beforeBson.clone(), keyBson);
        } else if (afterRecord.value() != null) {
            afterBson = BsonDocument.parse((String)afterRecord.value().toString());
        }
        return this.newRecord(record, keyBson, beforeBson, afterBson);
    }

    public ConfigDef config() {
        return CONFIG_DEF;
    }

    public void close() {
    }

    public void configure(Map<String, ?> configs) {
        ArrayEncoding arrayMode = ArrayEncoding.parse((String)configs.get(ARRAY_HANDLING_MODE_KEY), "array");
        this.converter = new MongoDataConverter(arrayMode);
    }

    private BsonDocument buildAfterBsonFromPartials(SinkRecord updateDescriptionRecord, BsonDocument initialDocument, BsonDocument keyBson) {
        Struct updateAsStruct = Requirements.requireStruct((Object)updateDescriptionRecord.value(), (String)UPDATE_DESCRIPTION);
        String updated = updateAsStruct.getString(UPDATED_FIELDS);
        List removed = updateAsStruct.getArray(REMOVED_FIELDS);
        BsonDocument updatedBson = BsonDocument.parse((String)updated);
        for (Map.Entry valueEntry : updatedBson.entrySet()) {
            initialDocument.append((String)valueEntry.getKey(), (BsonValue)valueEntry.getValue());
        }
        if (removed != null) {
            for (String field : removed) {
                initialDocument.keySet().remove(field);
            }
        }
        if (!initialDocument.containsKey((Object)"_id")) {
            initialDocument.append("_id", keyBson.get((Object)"id"));
        }
        return initialDocument;
    }

    private SinkRecord newRecord(SinkRecord record, BsonDocument keyDocument, BsonDocument beforeBson, BsonDocument afterBson) {
        SchemaBuilder keySchemaBuilder = SchemaBuilder.struct();
        Set keyPairs = keyDocument.entrySet();
        for (Map.Entry keyPairsForSchema : keyPairs) {
            this.converter.addFieldSchema(keyPairsForSchema, keySchemaBuilder);
        }
        Schema newKeySchema = keySchemaBuilder.build();
        Struct newKeyStruct = new Struct(newKeySchema);
        for (Map.Entry keyPairsForStruct : keyPairs) {
            this.converter.convertRecord(keyPairsForStruct, newKeySchema, newKeyStruct);
        }
        Struct oldValue = Requirements.requireStruct((Object)record.value(), (String)"copying existing fields besides before/after");
        Schema oldSchema = oldValue.schema();
        SchemaBuilder newValueSchemaBuilder = SchemaBuilder.struct().name(oldSchema.name());
        oldSchema.fields().forEach(field -> {
            if (field.name().equals(AFTER_FIELD_NAME)) {
                if (afterBson != null) {
                    this.mutateBuilderFromBson(newValueSchemaBuilder, afterBson, AFTER_FIELD_NAME);
                }
            } else if (field.name().equals(BEFORE_FIELD_NAME)) {
                if (beforeBson != null) {
                    this.mutateBuilderFromBson(newValueSchemaBuilder, beforeBson, BEFORE_FIELD_NAME);
                }
            } else {
                newValueSchemaBuilder.field(field.name(), field.schema());
            }
        });
        Schema newValueSchema = newValueSchemaBuilder.build();
        Struct newValueStruct = new Struct(newValueSchemaBuilder.build());
        newValueSchema.fields().forEach(field -> {
            if (field.name().equals(AFTER_FIELD_NAME)) {
                if (afterBson != null) {
                    newValueStruct.put(field.name(), (Object)this.fillStructFromBson(field.schema(), afterBson));
                }
            } else if (field.name().equals(BEFORE_FIELD_NAME)) {
                if (beforeBson != null) {
                    newValueStruct.put(field.name(), (Object)this.fillStructFromBson(field.schema(), beforeBson));
                }
            } else {
                newValueStruct.put(field.name(), oldValue.get(field.name()));
            }
        });
        return record.newRecord(record.topic(), record.kafkaPartition(), newKeySchema, (Object)newKeyStruct, newValueSchema, (Object)newValueStruct, record.timestamp(), (Iterable)record.headers());
    }

    private void mutateBuilderFromBson(SchemaBuilder builder, BsonDocument bson, String fieldName) {
        SchemaBuilder innerBuilder = SchemaBuilder.struct();
        Set pairs = bson.entrySet();
        for (Map.Entry pairsForSchema : pairs) {
            this.converter.addFieldSchema(pairsForSchema, innerBuilder);
        }
        builder.field(fieldName, innerBuilder.optional().build());
    }

    private Struct fillStructFromBson(Schema schema, BsonDocument bson) {
        Struct struct = new Struct(schema);
        Set pairs = bson.entrySet();
        for (Map.Entry pairsForSchema : pairs) {
            this.converter.convertRecord(pairsForSchema, schema, struct);
        }
        return struct;
    }

    private boolean isValidKey(SinkRecord record) {
        return record.keySchema() != null && record.keySchema().name() != null && record.keySchema().name().endsWith(RECORD_ENVELOPE_KEY_SCHEMA_NAME_SUFFIX);
    }

    private boolean isValidValue(SinkRecord record) {
        return record.valueSchema() != null && record.valueSchema().name() != null && record.valueSchema().name().endsWith(SCHEMA_NAME_SUFFIX);
    }

    private static <R extends ConnectRecord<R>> ExtractField<R> extractorValueField(String field) {
        ExtractField.Value extractField = new ExtractField.Value();
        HashMap target = Maps.newHashMap();
        target.put("field", field);
        extractField.configure((Map)target);
        return extractField;
    }

    private static ExtractField<SinkRecord> extractorForKeyField(String field) {
        ExtractField.Key extractField = new ExtractField.Key();
        HashMap target = Maps.newHashMap();
        target.put("field", field);
        extractField.configure((Map)target);
        return extractField;
    }

    private String kafkaMetadataForException(SinkRecord record) {
        return String.format("topic: %s, partition: %s, offset: %s", record.topic(), record.kafkaPartition(), record.kafkaOffset());
    }
}

