/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.connect.transforms;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.iceberg.relocated.com.google.common.base.Splitter;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.sink.SinkRecord;
import org.apache.kafka.connect.transforms.Transformation;
import org.apache.kafka.connect.transforms.util.Requirements;
import org.apache.kafka.connect.transforms.util.SchemaUtil;
import org.apache.kafka.connect.transforms.util.SimpleConfig;

public class KafkaMetadataTransform
implements Transformation<SinkRecord> {
    private static final String TOPIC = "topic";
    private static final String PARTITION = "partition";
    private static final String OFFSET = "offset";
    private static final String TIMESTAMP = "timestamp";
    private static final String EXTERNAL_KAFKA_METADATA = "external_field";
    private static final String KEY_METADATA_FIELD_NAME = "field_name";
    private static final String KEY_METADATA_IS_NESTED = "nested";
    private static final String DEFAULT_METADATA_FIELD_NAME = "_kafka_metadata";
    private static RecordAppender recordAppender;
    private static final ConfigDef CONFIG_DEF;

    private static RecordAppender getExternalFieldAppender(String field, Function<String, String> fieldNamer) {
        if (field == null) {
            return new NoOpRecordAppender();
        }
        List parts = Splitter.on((char)',').splitToList((CharSequence)field);
        if (parts.size() != 2) {
            throw new ConfigException(String.format("Could not parse %s for %s", field, EXTERNAL_KAFKA_METADATA));
        }
        final String fieldName = fieldNamer.apply((String)parts.get(0));
        final String fieldValue = (String)parts.get(1);
        return new RecordAppender(){

            @Override
            public void addToSchema(SchemaBuilder builder) {
                builder.field(fieldName, Schema.STRING_SCHEMA);
            }

            @Override
            public void addToStruct(SinkRecord record, Struct struct) {
                struct.put(fieldName, (Object)fieldValue);
            }

            @Override
            public void addToMap(SinkRecord record, Map<String, Object> map) {
                map.put(fieldName, fieldValue);
            }
        };
    }

    private static RecordAppender getRecordAppender(Map<String, ?> props) {
        SimpleConfig config = new SimpleConfig(CONFIG_DEF, props);
        return KafkaMetadataTransform.getRecordAppender(config);
    }

    private static RecordAppender getRecordAppender(SimpleConfig config) {
        final String metadataFieldName = config.getString(KEY_METADATA_FIELD_NAME);
        Boolean nestedMetadata = config.getBoolean(KEY_METADATA_IS_NESTED);
        if (nestedMetadata.booleanValue()) {
            final RecordAppender externalFieldAppender = KafkaMetadataTransform.getExternalFieldAppender(config.getString(EXTERNAL_KAFKA_METADATA), name -> name);
            SchemaBuilder nestedSchemaBuilder = SchemaBuilder.struct();
            nestedSchemaBuilder.field(TOPIC, Schema.STRING_SCHEMA).field(PARTITION, Schema.INT32_SCHEMA).field(OFFSET, Schema.INT64_SCHEMA).field(TIMESTAMP, Schema.OPTIONAL_INT64_SCHEMA);
            externalFieldAppender.addToSchema(nestedSchemaBuilder);
            final Schema nestedSchema = nestedSchemaBuilder.build();
            return new RecordAppender(){

                @Override
                public void addToSchema(SchemaBuilder builder) {
                    builder.field(metadataFieldName, nestedSchema);
                }

                @Override
                public void addToStruct(SinkRecord record, Struct struct) {
                    Struct nested = new Struct(nestedSchema);
                    nested.put(KafkaMetadataTransform.TOPIC, (Object)record.topic());
                    nested.put(KafkaMetadataTransform.PARTITION, (Object)record.kafkaPartition());
                    nested.put(KafkaMetadataTransform.OFFSET, (Object)record.kafkaOffset());
                    if (record.timestamp() != null) {
                        nested.put(KafkaMetadataTransform.TIMESTAMP, (Object)record.timestamp());
                    }
                    externalFieldAppender.addToStruct(record, nested);
                    struct.put(metadataFieldName, (Object)nested);
                }

                @Override
                public void addToMap(SinkRecord record, Map<String, Object> map) {
                    HashMap nested = Maps.newHashMap();
                    nested.put(KafkaMetadataTransform.TOPIC, record.topic());
                    nested.put(KafkaMetadataTransform.PARTITION, record.kafkaPartition());
                    nested.put(KafkaMetadataTransform.OFFSET, record.kafkaOffset());
                    if (record.timestamp() != null) {
                        nested.put(KafkaMetadataTransform.TIMESTAMP, record.timestamp());
                    }
                    externalFieldAppender.addToMap(record, nested);
                    map.put(metadataFieldName, nested);
                }
            };
        }
        Function<String, String> namer = name -> String.format("%s_%s", metadataFieldName, name);
        final String topicFieldName = namer.apply(TOPIC);
        final String partitionFieldName = namer.apply(PARTITION);
        final String offsetFieldName = namer.apply(OFFSET);
        final String timestampFieldName = namer.apply(TIMESTAMP);
        final RecordAppender externalFieldAppender = KafkaMetadataTransform.getExternalFieldAppender(config.getString(EXTERNAL_KAFKA_METADATA), namer);
        return new RecordAppender(){

            @Override
            public void addToSchema(SchemaBuilder builder) {
                builder.field(topicFieldName, Schema.STRING_SCHEMA).field(partitionFieldName, Schema.INT32_SCHEMA).field(offsetFieldName, Schema.INT64_SCHEMA).field(timestampFieldName, Schema.OPTIONAL_INT64_SCHEMA);
                externalFieldAppender.addToSchema(builder);
            }

            @Override
            public void addToStruct(SinkRecord record, Struct struct) {
                struct.put(topicFieldName, (Object)record.topic());
                struct.put(partitionFieldName, (Object)record.kafkaPartition());
                struct.put(offsetFieldName, (Object)record.kafkaOffset());
                if (record.timestamp() != null) {
                    struct.put(timestampFieldName, (Object)record.timestamp());
                }
                externalFieldAppender.addToStruct(record, struct);
            }

            @Override
            public void addToMap(SinkRecord record, Map<String, Object> map) {
                map.put(topicFieldName, record.topic());
                map.put(partitionFieldName, record.kafkaPartition());
                map.put(offsetFieldName, record.kafkaOffset());
                if (record.timestamp() != null) {
                    map.put(timestampFieldName, record.timestamp());
                }
                externalFieldAppender.addToMap(record, map);
            }
        };
    }

    public SinkRecord apply(SinkRecord record) {
        if (record.value() == null) {
            return record;
        }
        if (record.valueSchema() == null) {
            return this.applySchemaless(record);
        }
        return this.applyWithSchema(record);
    }

    private SinkRecord applyWithSchema(SinkRecord record) {
        Struct value = Requirements.requireStruct((Object)record.value(), (String)"KafkaMetadataTransform");
        Schema newSchema = this.makeUpdatedSchema(record.valueSchema());
        Struct newValue = new Struct(newSchema);
        for (Field field : record.valueSchema().fields()) {
            newValue.put(field.name(), value.get(field));
        }
        recordAppender.addToStruct(record, newValue);
        return record.newRecord(record.topic(), record.kafkaPartition(), record.keySchema(), record.key(), newSchema, (Object)newValue, record.timestamp(), (Iterable)record.headers());
    }

    private Schema makeUpdatedSchema(Schema schema) {
        SchemaBuilder builder = SchemaUtil.copySchemaBasics((Schema)schema, (SchemaBuilder)SchemaBuilder.struct());
        for (Field field : schema.fields()) {
            builder.field(field.name(), field.schema());
        }
        recordAppender.addToSchema(builder);
        return builder.build();
    }

    private SinkRecord applySchemaless(SinkRecord record) {
        Map value = Requirements.requireMap((Object)record.value(), (String)"KafkaMetadata transform");
        HashMap newValue = Maps.newHashMap((Map)value);
        recordAppender.addToMap(record, newValue);
        return record.newRecord(record.topic(), record.kafkaPartition(), record.keySchema(), record.key(), null, (Object)newValue, record.timestamp(), (Iterable)record.headers());
    }

    public ConfigDef config() {
        return CONFIG_DEF;
    }

    public void close() {
    }

    public void configure(Map<String, ?> configs) {
        recordAppender = KafkaMetadataTransform.getRecordAppender(configs);
    }

    static {
        CONFIG_DEF = new ConfigDef().define(KEY_METADATA_FIELD_NAME, ConfigDef.Type.STRING, (Object)DEFAULT_METADATA_FIELD_NAME, ConfigDef.Importance.LOW, "the field to append Kafka metadata under (or prefix fields with)").define(KEY_METADATA_IS_NESTED, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, "(true/false) to make a nested record under name or prefix names on the top level").define(EXTERNAL_KAFKA_METADATA, ConfigDef.Type.STRING, null, ConfigDef.Importance.LOW, "key,value representing a String to be injected on Kafka metadata (e.g. Cluster)");
    }

    private static class NoOpRecordAppender
    implements RecordAppender {
        private NoOpRecordAppender() {
        }

        @Override
        public void addToSchema(SchemaBuilder builder) {
        }

        @Override
        public void addToStruct(SinkRecord record, Struct struct) {
        }

        @Override
        public void addToMap(SinkRecord record, Map<String, Object> map) {
        }
    }

    private static interface RecordAppender {
        public void addToSchema(SchemaBuilder var1);

        public void addToStruct(SinkRecord var1, Struct var2);

        public void addToMap(SinkRecord var1, Map<String, Object> var2);
    }
}

