/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.connect.transforms;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BigIntegerNode;
import com.fasterxml.jackson.databind.node.BinaryNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DecimalNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.FloatNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.connect.transforms.JsonToMapException;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;

class JsonToMapUtils {
    private static final String DECIMAL_LOGICAL_NAME = "org.apache.kafka.connect.data.Decimal";
    private static final String SCALE_FIELD = "scale";
    public static final Schema ARRAY_OPTIONAL_STRING = SchemaBuilder.array((Schema)Schema.OPTIONAL_STRING_SCHEMA).optional().build();
    public static final Schema ARRAY_MAP_OPTIONAL_STRING = SchemaBuilder.array((Schema)SchemaBuilder.map((Schema)Schema.OPTIONAL_STRING_SCHEMA, (Schema)Schema.OPTIONAL_STRING_SCHEMA).optional().build()).optional().build();
    public static final Schema ARRAY_ARRAY_OPTIONAL_STRING = SchemaBuilder.array((Schema)SchemaBuilder.array((Schema)Schema.OPTIONAL_STRING_SCHEMA).optional().build()).optional().build();
    private static final Map<Class<? extends JsonNode>, Schema> JSON_NODE_TO_SCHEMA = JsonToMapUtils.getJsonNodeToSchema();

    private static SchemaBuilder decimalBuilder(int scale) {
        return SchemaBuilder.bytes().name(DECIMAL_LOGICAL_NAME).parameter(SCALE_FIELD, Integer.toString(scale)).version(Integer.valueOf(1));
    }

    public static Schema decimalSchema(int scale) {
        return JsonToMapUtils.decimalBuilder(scale).optional().build();
    }

    private JsonToMapUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static Map<Class<? extends JsonNode>, Schema> getJsonNodeToSchema() {
        HashMap map = Maps.newHashMap();
        map.put(BinaryNode.class, Schema.OPTIONAL_BYTES_SCHEMA);
        map.put(BooleanNode.class, Schema.OPTIONAL_BOOLEAN_SCHEMA);
        map.put(TextNode.class, Schema.OPTIONAL_STRING_SCHEMA);
        map.put(IntNode.class, Schema.OPTIONAL_INT32_SCHEMA);
        map.put(LongNode.class, Schema.OPTIONAL_INT64_SCHEMA);
        map.put(FloatNode.class, Schema.OPTIONAL_FLOAT32_SCHEMA);
        map.put(DoubleNode.class, Schema.OPTIONAL_FLOAT64_SCHEMA);
        map.put(ArrayNode.class, Schema.OPTIONAL_STRING_SCHEMA);
        map.put(ObjectNode.class, SchemaBuilder.map((Schema)Schema.STRING_SCHEMA, (Schema)Schema.STRING_SCHEMA).optional().build());
        map.put(BigIntegerNode.class, JsonToMapUtils.decimalSchema(0));
        map.put(DecimalNode.class, Schema.OPTIONAL_STRING_SCHEMA);
        return ImmutableMap.copyOf((Map)map);
    }

    public static void addField(Map.Entry<String, JsonNode> kv, SchemaBuilder builder) {
        String key = kv.getKey();
        Schema schema = JsonToMapUtils.schemaFromNode(kv.getValue());
        if (schema != null) {
            builder.field(key, schema);
        }
    }

    public static Schema schemaFromNode(JsonNode node) {
        if (!node.isNull() && !node.isMissingNode()) {
            if (node.isArray()) {
                return JsonToMapUtils.arraySchema((ArrayNode)node);
            }
            if (node.isObject()) {
                if (node.elements().hasNext()) {
                    return JSON_NODE_TO_SCHEMA.get(node.getClass());
                }
            } else {
                return JSON_NODE_TO_SCHEMA.get(node.getClass());
            }
        }
        return null;
    }

    private static Schema arraySchema(ArrayNode array) {
        Object result;
        if (array.isEmpty()) {
            result = null;
        } else {
            Class<? extends JsonNode> arrayType = JsonToMapUtils.arrayNodeType(array);
            if (arrayType == null) {
                result = ARRAY_OPTIONAL_STRING;
            } else if (arrayType == NullNode.class || arrayType == MissingNode.class) {
                result = ARRAY_OPTIONAL_STRING;
            } else if (arrayType == ObjectNode.class) {
                result = ARRAY_MAP_OPTIONAL_STRING;
            } else if (arrayType == ArrayNode.class) {
                Schema nestedArraySchema;
                HashSet nestedSchemas = Sets.newHashSet();
                array.elements().forEachRemaining(node -> nestedSchemas.add(JsonToMapUtils.schemaFromNode(node)));
                result = nestedSchemas.size() > 1 ? SchemaBuilder.array((Schema)ARRAY_OPTIONAL_STRING).optional().build() : ((nestedArraySchema = (Schema)nestedSchemas.iterator().next()) == null ? null : SchemaBuilder.array((Schema)nestedArraySchema).optional().build());
            } else {
                result = SchemaBuilder.array((Schema)JSON_NODE_TO_SCHEMA.get(arrayType)).optional().build();
            }
        }
        return result;
    }

    public static Class<? extends JsonNode> arrayNodeType(ArrayNode array) {
        HashSet elementTypes = Sets.newHashSet();
        array.elements().forEachRemaining(node -> elementTypes.add(node.getClass()));
        Class result = elementTypes.isEmpty() ? null : (elementTypes.size() == 1 ? (Class)elementTypes.iterator().next() : null);
        return result;
    }

    public static Struct addToStruct(ObjectNode node, Schema schema, Struct struct) {
        schema.fields().forEach(field -> {
            JsonNode element = node.get(field.name());
            Schema.Type targetType = field.schema().type();
            switch (targetType) {
                case ARRAY: {
                    struct.put(field.name(), JsonToMapUtils.populateArray(element, field.schema().valueSchema(), field.name(), Lists.newArrayList()));
                    break;
                }
                case MAP: {
                    struct.put(field.name(), JsonToMapUtils.populateMap(element, Maps.newHashMap()));
                    break;
                }
                default: {
                    struct.put(field.name(), JsonToMapUtils.extractValue(element, targetType, field.name()));
                }
            }
        });
        return struct;
    }

    public static Object extractValue(JsonNode node, Schema.Type type, String fieldName) {
        Object obj;
        switch (type) {
            case STRING: {
                obj = JsonToMapUtils.nodeToText(node);
                break;
            }
            case BOOLEAN: {
                obj = node.booleanValue();
                break;
            }
            case INT32: {
                obj = node.intValue();
                break;
            }
            case INT64: {
                obj = node.longValue();
                break;
            }
            case FLOAT32: {
                obj = Float.valueOf(node.floatValue());
                break;
            }
            case FLOAT64: {
                obj = node.doubleValue();
                break;
            }
            case MAP: {
                ObjectNode mapNode = (ObjectNode)node;
                HashMap map = Maps.newHashMap();
                JsonToMapUtils.populateMap((JsonNode)mapNode, map);
                obj = map;
                break;
            }
            case BYTES: {
                obj = JsonToMapUtils.extractBytes(node, fieldName);
                break;
            }
            default: {
                throw new JsonToMapException(String.format("Unexpected type %s for field %s", type, fieldName));
            }
        }
        return obj;
    }

    private static Object extractBytes(JsonNode node, String fieldName) {
        Object obj;
        try {
            obj = node.isBigInteger() ? new BigDecimal(node.bigIntegerValue()) : (node.isBigDecimal() ? node.decimalValue() : (Object)node.binaryValue());
        }
        catch (Exception e) {
            throw new JsonToMapException(String.format("parsing binary value threw exception for %s", fieldName), e);
        }
        return obj;
    }

    private static List<Object> populateArray(JsonNode node, Schema schema, String fieldName, List<Object> acc) {
        if (schema.type() == Schema.Type.ARRAY) {
            node.elements().forEachRemaining(arrayNode -> {
                ArrayList nestedList = Lists.newArrayList();
                acc.add(JsonToMapUtils.populateArray(arrayNode, schema.valueSchema(), fieldName, nestedList));
            });
        } else {
            node.elements().forEachRemaining(arrayEntry -> acc.add(JsonToMapUtils.extractValue(arrayEntry, schema.type(), fieldName)));
        }
        return acc;
    }

    public static Map<String, String> populateMap(JsonNode node, Map<String, String> map) {
        Iterator it = node.fields();
        while (it.hasNext()) {
            Map.Entry element = (Map.Entry)it.next();
            map.put((String)element.getKey(), JsonToMapUtils.nodeToText((JsonNode)element.getValue()));
        }
        return map;
    }

    private static String nodeToText(JsonNode node) {
        if (node.isTextual()) {
            return node.textValue();
        }
        return node.toString();
    }
}

