/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.connect.transforms;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Locale;
import java.util.Map;
import org.apache.iceberg.connect.transforms.JsonToMapException;
import org.apache.iceberg.connect.transforms.JsonToMapUtils;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.sink.SinkRecord;
import org.apache.kafka.connect.transforms.Transformation;
import org.apache.kafka.connect.transforms.util.SimpleConfig;

public class JsonToMapTransform<R extends ConnectRecord<R>>
implements Transformation<R> {
    public static final String JSON_LEVEL = "json.root";
    private static final ObjectReader MAPPER = new ObjectMapper().reader();
    private boolean startAtRoot = false;
    public static final ConfigDef CONFIG_DEF = new ConfigDef().define("json.root", ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.MEDIUM, "Boolean value to start at root. False is one level in from the root");
    private static final String ALL_JSON_SCHEMA_FIELD = "payload";
    private static final Schema JSON_MAP_SCHEMA = SchemaBuilder.struct().field("payload", SchemaBuilder.map((Schema)Schema.STRING_SCHEMA, (Schema)Schema.STRING_SCHEMA).optional().build()).build();

    public R apply(R record) {
        if (record.value() == null) {
            return record;
        }
        return this.process(record);
    }

    private R process(R record) {
        JsonNode obj;
        if (!(record.value() instanceof String)) {
            throw new JsonToMapException("record value is not a string, use StringConverter");
        }
        String json = (String)record.value();
        try {
            obj = MAPPER.readTree(json);
        }
        catch (Exception e) {
            throw new JsonToMapException(String.format("record.value is not valid json for record.value: %s", this.collectRecordDetails(record)), e);
        }
        if (!(obj instanceof ObjectNode)) {
            throw new JsonToMapException(String.format("Expected json object for record.value after parsing: %s", this.collectRecordDetails(record)));
        }
        if (this.startAtRoot) {
            return this.singleField(record, (ObjectNode)obj);
        }
        return this.structRecord(record, (ObjectNode)obj);
    }

    private R singleField(R record, ObjectNode obj) {
        Struct struct = new Struct(JSON_MAP_SCHEMA).put(ALL_JSON_SCHEMA_FIELD, JsonToMapUtils.populateMap((JsonNode)obj, Maps.newHashMap()));
        return (R)record.newRecord(record.topic(), record.kafkaPartition(), record.keySchema(), record.key(), JSON_MAP_SCHEMA, (Object)struct, record.timestamp(), (Iterable)record.headers());
    }

    private R structRecord(R record, ObjectNode contents) {
        SchemaBuilder builder = SchemaBuilder.struct();
        contents.fields().forEachRemaining(entry -> JsonToMapUtils.addField(entry, builder));
        Schema schema = builder.build();
        Struct value = JsonToMapUtils.addToStruct(contents, schema, new Struct(schema));
        return (R)record.newRecord(record.topic(), record.kafkaPartition(), record.keySchema(), record.key(), schema, (Object)value, record.timestamp(), (Iterable)record.headers());
    }

    private String collectRecordDetails(R record) {
        if (record instanceof SinkRecord) {
            SinkRecord sinkRecord = (SinkRecord)record;
            return String.format("topic %s partition %s offset %s", sinkRecord.topic(), sinkRecord.kafkaPartition(), sinkRecord.kafkaOffset());
        }
        return String.format(Locale.ROOT, "topic %s partition %S", record.topic(), record.kafkaPartition());
    }

    public ConfigDef config() {
        return CONFIG_DEF;
    }

    public void close() {
    }

    public void configure(Map<String, ?> configs) {
        SimpleConfig config = new SimpleConfig(CONFIG_DEF, configs);
        this.startAtRoot = config.getBoolean(JSON_LEVEL);
    }
}

