/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.connect.transforms;

import java.util.HashMap;
import java.util.Map;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.transforms.Transformation;
import org.apache.kafka.connect.transforms.util.Requirements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DmsTransform<R extends ConnectRecord<R>>
implements Transformation<R> {
    private static final Logger LOG = LoggerFactory.getLogger((String)DmsTransform.class.getName());
    private static final ConfigDef EMPTY_CONFIG = new ConfigDef();

    public R apply(R record) {
        if (record.value() == null) {
            return record;
        }
        if (record.valueSchema() == null) {
            return this.applySchemaless(record);
        }
        throw new UnsupportedOperationException("Schema not support for DMS records");
    }

    private R applySchemaless(R record) {
        String op;
        String dmsOp;
        Map value = Requirements.requireMap((Object)record.value(), (String)"DMS transform");
        Object dataObj = value.get("data");
        Object metadataObj = value.get("metadata");
        if (!(dataObj instanceof Map) || !(metadataObj instanceof Map)) {
            LOG.debug("Unable to transform DMS record, skipping...");
            return null;
        }
        Map metadata = (Map)metadataObj;
        switch (dmsOp = metadata.get("operation").toString()) {
            case "update": {
                op = "U";
                break;
            }
            case "delete": {
                op = "D";
                break;
            }
            default: {
                op = "I";
            }
        }
        HashMap cdcMetadata = Maps.newHashMap();
        cdcMetadata.put("op", op);
        cdcMetadata.put("ts", metadata.get("timestamp"));
        cdcMetadata.put("source", String.format("%s.%s", metadata.get("schema-name"), metadata.get("table-name")));
        HashMap newValue = Maps.newHashMap((Map)((Map)dataObj));
        newValue.put("_cdc", cdcMetadata);
        return (R)record.newRecord(record.topic(), record.kafkaPartition(), record.keySchema(), record.key(), null, (Object)newValue, record.timestamp());
    }

    public ConfigDef config() {
        return EMPTY_CONFIG;
    }

    public void close() {
    }

    public void configure(Map<String, ?> configs) {
    }
}

