/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.connect.transforms;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.data.Timestamp;
import org.apache.kafka.connect.sink.SinkRecord;
import org.apache.kafka.connect.transforms.Transformation;
import org.apache.kafka.connect.transforms.util.Requirements;
import org.apache.kafka.connect.transforms.util.SchemaUtil;
import org.apache.kafka.connect.transforms.util.SimpleConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebeziumTransform<R extends ConnectRecord<R>>
implements Transformation<R> {
    private static final Logger LOG = LoggerFactory.getLogger((String)DebeziumTransform.class.getName());
    private static final String CDC_TARGET_PATTERN = "cdc.target.pattern";
    private static final String DB_PLACEHOLDER = "{db}";
    private static final String TABLE_PLACEHOLDER = "{table}";
    public static final ConfigDef CONFIG_DEF = new ConfigDef().define("cdc.target.pattern", ConfigDef.Type.STRING, null, ConfigDef.Importance.MEDIUM, "Pattern to use for setting the CDC target field value.");
    private String cdcTargetPattern;

    public void configure(Map<String, ?> props) {
        SimpleConfig config = new SimpleConfig(CONFIG_DEF, props);
        this.cdcTargetPattern = config.getString(CDC_TARGET_PATTERN);
    }

    public R apply(R record) {
        if (record.value() == null) {
            return record;
        }
        if (record.valueSchema() == null) {
            return this.applySchemaless(record);
        }
        return this.applyWithSchema(record);
    }

    private R applyWithSchema(R record) {
        Schema payloadSchema;
        Struct payload;
        Struct value = Requirements.requireStruct((Object)record.value(), (String)"Debezium transform");
        String op = this.mapOperation(value.get("op").toString());
        if (op.equals("D")) {
            payload = value.getStruct("before");
            payloadSchema = value.schema().field("before").schema();
        } else {
            payload = value.getStruct("after");
            payloadSchema = value.schema().field("after").schema();
        }
        Schema cdcSchema = this.makeCdcSchema(record.keySchema());
        Struct cdcMetadata = new Struct(cdcSchema);
        cdcMetadata.put("op", (Object)op);
        cdcMetadata.put("ts", (Object)new Date(value.getInt64("ts_ms")));
        if (record instanceof SinkRecord) {
            cdcMetadata.put("offset", (Object)((SinkRecord)record).kafkaOffset());
        }
        this.setTableAndTargetFromSourceStruct(value.getStruct("source"), cdcMetadata);
        if (record.keySchema() != null) {
            cdcMetadata.put("key", record.key());
        }
        Schema newValueSchema = this.makeUpdatedSchema(payloadSchema, cdcSchema);
        Struct newValue = new Struct(newValueSchema);
        for (Field field : payloadSchema.fields()) {
            newValue.put(field.name(), payload.get(field));
        }
        newValue.put("_cdc", (Object)cdcMetadata);
        return (R)record.newRecord(record.topic(), record.kafkaPartition(), record.keySchema(), record.key(), newValueSchema, (Object)newValue, record.timestamp());
    }

    private R applySchemaless(R record) {
        Map value = Requirements.requireMap((Object)record.value(), (String)"Debezium transform");
        String op = this.mapOperation(value.get("op").toString());
        Object payload = op.equals("D") ? value.get("before") : value.get("after");
        if (!(payload instanceof Map)) {
            LOG.debug("Unable to transform Debezium record, payload is not a map, skipping");
            return null;
        }
        HashMap cdcMetadata = Maps.newHashMap();
        cdcMetadata.put("op", op);
        cdcMetadata.put("ts", value.get("ts_ms"));
        if (record instanceof SinkRecord) {
            cdcMetadata.put("offset", ((SinkRecord)record).kafkaOffset());
        }
        this.setTableAndTargetFromSourceMap(value.get("source"), cdcMetadata);
        if (record.key() instanceof Map) {
            cdcMetadata.put("key", record.key());
        }
        HashMap newValue = Maps.newHashMap((Map)((Map)payload));
        newValue.put("_cdc", cdcMetadata);
        return (R)record.newRecord(record.topic(), record.kafkaPartition(), record.keySchema(), record.key(), null, (Object)newValue, record.timestamp());
    }

    private String mapOperation(String originalOp) {
        switch (originalOp) {
            case "u": {
                return "U";
            }
            case "d": {
                return "D";
            }
        }
        return "I";
    }

    private void setTableAndTargetFromSourceStruct(Struct source, Struct cdcMetadata) {
        String db = source.schema().field("schema") != null ? source.getString("schema") : source.getString("db");
        String table = source.getString("table");
        cdcMetadata.put("source", (Object)(db + "." + table));
        cdcMetadata.put("target", (Object)this.target(db, table));
    }

    private void setTableAndTargetFromSourceMap(Object source, Map<String, Object> cdcMetadata) {
        Map map = Requirements.requireMap((Object)source, (String)"Debezium transform");
        String db = map.containsKey("schema") ? map.get("schema").toString() : map.get("db").toString();
        String table = map.get("table").toString();
        cdcMetadata.put("source", db + "." + table);
        cdcMetadata.put("target", this.target(db, table));
    }

    private String target(String db, String table) {
        return this.cdcTargetPattern == null || this.cdcTargetPattern.isEmpty() ? db + "." + table : this.cdcTargetPattern.replace(DB_PLACEHOLDER, db).replace(TABLE_PLACEHOLDER, table);
    }

    private Schema makeCdcSchema(Schema keySchema) {
        SchemaBuilder builder = SchemaBuilder.struct().field("op", Schema.STRING_SCHEMA).field("ts", Timestamp.SCHEMA).field("offset", Schema.OPTIONAL_INT64_SCHEMA).field("source", Schema.STRING_SCHEMA).field("target", Schema.STRING_SCHEMA);
        if (keySchema != null) {
            builder.field("key", keySchema);
        }
        return builder.build();
    }

    private Schema makeUpdatedSchema(Schema schema, Schema cdcSchema) {
        SchemaBuilder builder = SchemaUtil.copySchemaBasics((Schema)schema, (SchemaBuilder)SchemaBuilder.struct());
        for (Field field : schema.fields()) {
            builder.field(field.name(), field.schema());
        }
        builder.field("_cdc", cdcSchema);
        return builder.build();
    }

    public ConfigDef config() {
        return CONFIG_DEF;
    }

    public void close() {
    }
}

