/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.connect.transforms;

import java.util.HashMap;
import java.util.Map;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.kafka.common.cache.Cache;
import org.apache.kafka.common.cache.LRUCache;
import org.apache.kafka.common.cache.SynchronizedCache;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.transforms.Transformation;
import org.apache.kafka.connect.transforms.util.Requirements;
import org.apache.kafka.connect.transforms.util.SchemaUtil;
import org.apache.kafka.connect.transforms.util.SimpleConfig;

public class CopyValue<R extends ConnectRecord<R>>
implements Transformation<R> {
    private static final String SOURCE_FIELD = "source.field";
    private static final String TARGET_FIELD = "target.field";
    public static final ConfigDef CONFIG_DEF = new ConfigDef().define("source.field", ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, "Source field name.").define("target.field", ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, "Target field name.");
    private String sourceField;
    private String targetField;
    private Cache<Schema, Schema> schemaUpdateCache;

    public void configure(Map<String, ?> props) {
        SimpleConfig config = new SimpleConfig(CONFIG_DEF, props);
        this.sourceField = config.getString(SOURCE_FIELD);
        this.targetField = config.getString(TARGET_FIELD);
        this.schemaUpdateCache = new SynchronizedCache((Cache)new LRUCache(16));
    }

    public R apply(R record) {
        if (record.value() == null) {
            return record;
        }
        if (record.valueSchema() == null) {
            return this.applySchemaless(record);
        }
        return this.applyWithSchema(record);
    }

    private R applySchemaless(R record) {
        Map value = Requirements.requireMap((Object)record.value(), (String)"copy value");
        HashMap updatedValue = Maps.newHashMap((Map)value);
        updatedValue.put(this.targetField, value.get(this.sourceField));
        return this.newRecord(record, null, updatedValue);
    }

    private R applyWithSchema(R record) {
        Struct value = Requirements.requireStruct((Object)record.value(), (String)"copy value");
        Schema updatedSchema = (Schema)this.schemaUpdateCache.get((Object)value.schema());
        if (updatedSchema == null) {
            updatedSchema = this.makeUpdatedSchema(value.schema());
            this.schemaUpdateCache.put((Object)value.schema(), (Object)updatedSchema);
        }
        Struct updatedValue = new Struct(updatedSchema);
        for (Field field : value.schema().fields()) {
            updatedValue.put(field.name(), value.get(field));
        }
        updatedValue.put(this.targetField, value.get(this.sourceField));
        return this.newRecord(record, updatedSchema, updatedValue);
    }

    private Schema makeUpdatedSchema(Schema schema) {
        SchemaBuilder builder = SchemaUtil.copySchemaBasics((Schema)schema, (SchemaBuilder)SchemaBuilder.struct());
        for (Field field : schema.fields()) {
            builder.field(field.name(), field.schema());
        }
        builder.field(this.targetField, schema.field(this.sourceField).schema());
        return builder.build();
    }

    public void close() {
        this.schemaUpdateCache = null;
    }

    public ConfigDef config() {
        return CONFIG_DEF;
    }

    protected R newRecord(R record, Schema updatedSchema, Object updatedValue) {
        return (R)record.newRecord(record.topic(), record.kafkaPartition(), record.keySchema(), record.key(), updatedSchema, updatedValue, record.timestamp());
    }
}

