/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data;

import java.io.Closeable;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.ContentScanTask;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.data.GenericDeleteFilter;
import org.apache.iceberg.data.IdentityPartitionConverters;
import org.apache.iceberg.data.InternalRecordWrapper;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.data.avro.PlannedDataReader;
import org.apache.iceberg.data.orc.GenericOrcReader;
import org.apache.iceberg.data.parquet.GenericParquetReaders;
import org.apache.iceberg.expressions.Evaluator;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.io.CloseableGroup;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.orc.ORC;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.util.PartitionUtil;
import org.apache.orc.TypeDescription;
import org.apache.parquet.schema.MessageType;

class GenericReader
implements Serializable {
    private final FileIO io;
    private final Schema tableSchema;
    private final Schema projection;
    private final boolean caseSensitive;
    private final boolean reuseContainers;

    GenericReader(TableScan scan, boolean reuseContainers) {
        this.io = scan.table().io();
        this.tableSchema = scan.table().schema();
        this.projection = scan.schema();
        this.caseSensitive = scan.isCaseSensitive();
        this.reuseContainers = reuseContainers;
    }

    CloseableIterator<Record> open(CloseableIterable<CombinedScanTask> tasks) {
        Iterable fileTasks = Iterables.concat((Iterable)Iterables.transform(tasks, CombinedScanTask::files));
        return CloseableIterable.concat((Iterable)Iterables.transform((Iterable)fileTasks, this::open)).iterator();
    }

    public CloseableIterable<Record> open(CombinedScanTask task) {
        return new CombinedTaskIterable(task);
    }

    public CloseableIterable<Record> open(FileScanTask task) {
        GenericDeleteFilter deletes = new GenericDeleteFilter(this.io, task, this.tableSchema, this.projection);
        Schema readSchema = deletes.requiredSchema();
        CloseableIterable<Record> records = this.openFile(task, readSchema);
        records = deletes.filter(records);
        records = this.applyResidual(records, readSchema, task.residual());
        return records;
    }

    private CloseableIterable<Record> applyResidual(CloseableIterable<Record> records, Schema recordSchema, Expression residual) {
        if (residual != null && residual != Expressions.alwaysTrue()) {
            InternalRecordWrapper wrapper = new InternalRecordWrapper(recordSchema.asStruct());
            Evaluator filter = new Evaluator(recordSchema.asStruct(), residual, this.caseSensitive);
            return CloseableIterable.filter(records, record -> filter.eval((StructLike)wrapper.wrap((StructLike)record)));
        }
        return records;
    }

    private CloseableIterable<Record> openFile(FileScanTask task, Schema fileProjection) {
        InputFile input = this.io.newInputFile((DataFile)task.file());
        Map partition = PartitionUtil.constantsMap((ContentScanTask)task, IdentityPartitionConverters::convertConstant);
        switch (((DataFile)task.file()).format()) {
            case AVRO: {
                Avro.ReadBuilder avro = Avro.read((InputFile)input).project(fileProjection).createResolvingReader(schema -> PlannedDataReader.create((Schema)schema, (Map)partition)).split(task.start(), task.length());
                if (this.reuseContainers) {
                    avro.reuseContainers();
                }
                return avro.build();
            }
            case PARQUET: {
                Parquet.ReadBuilder parquet = Parquet.read((InputFile)input).project(fileProjection).createReaderFunc(fileSchema -> GenericParquetReaders.buildReader((Schema)fileProjection, (MessageType)fileSchema, (Map)partition)).split(task.start(), task.length()).caseSensitive(this.caseSensitive).filter(task.residual());
                if (this.reuseContainers) {
                    parquet.reuseContainers();
                }
                return parquet.build();
            }
            case ORC: {
                Schema projectionWithoutConstantAndMetadataFields = TypeUtil.selectNot((Schema)fileProjection, (Set)Sets.union(partition.keySet(), (Set)MetadataColumns.metadataFieldIds()));
                ORC.ReadBuilder orc = ORC.read((InputFile)input).project(projectionWithoutConstantAndMetadataFields).createReaderFunc(fileSchema -> GenericOrcReader.buildReader((Schema)fileProjection, (TypeDescription)fileSchema, (Map)partition)).split(task.start(), task.length()).caseSensitive(this.caseSensitive).filter(task.residual());
                return orc.build();
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot read %s file: %s", ((DataFile)task.file()).format().name(), ((DataFile)task.file()).location()));
    }

    private class CombinedTaskIterable
    extends CloseableGroup
    implements CloseableIterable<Record> {
        private final CombinedScanTask task;

        private CombinedTaskIterable(CombinedScanTask task) {
            this.task = task;
        }

        public CloseableIterator<Record> iterator() {
            CloseableIterator iter = CloseableIterable.concat((Iterable)Iterables.transform((Iterable)this.task.files(), GenericReader.this::open)).iterator();
            this.addCloseable((Closeable)iter);
            return iter;
        }
    }
}

